/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import java.util.Set;

public class FormatterXMLElementNode
extends FormatterBlockWithBeginEndNode {
    private String element;
    private boolean children;

    public FormatterXMLElementNode(IFormatterDocument document, String element, boolean hasChildrenInAST) {
        super(document);
        this.element = element;
        this.children = hasChildrenInAST;
    }

    protected boolean isIndenting() {
        Set set = this.getDocument().getSet("xml.formatter.indent.excluded");
        return !set.contains(this.element);
    }

    protected boolean isAddingBeginNewLine() {
        return true;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return false;
    }

    protected boolean isAddingEndNewLine() {
        Set excludedTags = this.getDocument().getSet("xml.formatter.newline.excluded");
        boolean excludeNewLineOnTextNodes = this.getDocument().getBoolean("xml.formatter.newline.excluded.on.text.nodes");
        return this.children || !excludedTags.contains(this.element) && !excludeNewLineOnTextNodes;
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        if (context.getParent() == null) {
            return this.getInt("xml.formatter.line.after.element");
        }
        return super.getBlankLinesBefore(context);
    }

    protected int getBlankLinesBefore(IFormatterContext context) {
        if (context.getParent() != null && context.getChildIndex() > 1) {
            return this.getInt("xml.formatter.line.after.element");
        }
        return super.getBlankLinesBefore(context);
    }
}

