/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.formatter;

import beaver.Parser;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.formatter.XMLFormatterContext;
import com.aptana.editor.xml.formatter.XMLFormatterNodeBuilder;
import com.aptana.editor.xml.formatter.XMLFormatterNodeRewriter;
import com.aptana.editor.xml.formatter.XMLFormatterPlugin;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.ScriptFormattingContextProperties;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class XMLFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    protected XMLFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                XMLFormatterNodeBuilder builder = new XMLFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new XMLFormatterNodeRewriter().rewrite(root);
                XMLFormatterContext context = new XMLFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        block8: {
            String input = new String(source.substring(offset, offset + length));
            try {
                String output;
                IParseRootNode parseResult = null;
                try {
                    parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)input).getRootNode();
                }
                catch (Exception exception) {
                    return this.indent(source, input, offset, length, indentationLevel);
                }
                if (parseResult == null || (output = this.format(input, parseResult, indentationLevel, offset, isSelection)) == null) break block8;
                if (!input.equals(output)) {
                    if (this.equalsIgnoreWhitespaces(input, output)) {
                        return new ReplaceEdit(offset, length, output);
                    }
                    this.logError(input, output);
                    break block8;
                }
                return new MultiTextEdit();
            }
            catch (Parser.Exception e) {
                StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)e.getMessage()), (long)3000L, (boolean)true);
                if (FormatterPlugin.getDefault().isDebugging()) {
                    IdeLog.logError((Plugin)XMLFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
                }
            }
            catch (Exception e) {
                StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
                IdeLog.logError((Plugin)XMLFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
        return null;
    }

    public int getIndentSize() {
        return this.getInt("xml.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("xml.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("xml.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)XMLPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)XMLPlugin.getDefault().getPreferenceStore());
    }

    private String format(String input, IParseRootNode parseResult, int indentationLevel, int offset, boolean isSelection) throws Exception {
        int spacesCount = -1;
        if (isSelection) {
            spacesCount = XMLFormatter.countLeftWhitespaceChars((String)input);
        }
        XMLFormatterNodeBuilder builder = new XMLFormatterNodeBuilder();
        FormatterDocument document = this.createFormatterDocument(input, offset);
        IFormatterContainerNode root = builder.build((IParseNode)parseResult, document);
        new XMLFormatterNodeRewriter().rewrite(root);
        XMLFormatterContext context = new XMLFormatterContext(indentationLevel);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("xml.formatter.wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("xml.formatter.line.preserve"));
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        String output = writer.getOutput();
        List offOnRegions = builder.getOffOnRegions();
        if (offOnRegions != null && !offOnRegions.isEmpty()) {
            List outputOnOffRegions = this.getOutputOnOffRegions(output, this.getString("xml.formatter.formatter.off"), this.getString("xml.formatter.formatter.on"));
            output = FormatterUtils.applyOffOnRegions((String)input, (String)output, (List)offOnRegions, (List)outputOnOffRegions);
        }
        if (isSelection) {
            output = XMLFormatter.leftTrim((String)output, (int)spacesCount);
        }
        return output;
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("xml.formatter.formatter.tabulation.size", this.getInt("xml.formatter.formatter.tabulation.size"));
        document.setBoolean("xml.formatter.wrap.comments", this.getBoolean("xml.formatter.wrap.comments"));
        document.setBoolean("xml.formatter.newline.excluded.on.text.nodes", this.getBoolean("xml.formatter.newline.excluded.on.text.nodes"));
        document.setInt("xml.formatter.line.after.element", this.getInt("xml.formatter.line.after.element"));
        document.setSet("xml.formatter.indent.excluded", this.getSet("xml.formatter.indent.excluded", "!"));
        document.setSet("xml.formatter.newline.excluded", this.getSet("xml.formatter.newline.excluded", "!"));
        document.setInt(ScriptFormattingContextProperties.CONTEXT_ORIGINAL_OFFSET, offset);
        document.setBoolean("xml.formatter.formatter.on.off.enabled", this.getBoolean("xml.formatter.formatter.on.off.enabled"));
        document.setString("xml.formatter.formatter.on", this.getString("xml.formatter.formatter.on"));
        document.setString("xml.formatter.formatter.off", this.getString("xml.formatter.formatter.off"));
        return document;
    }
}

