/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerFieldEditor
extends FieldEditor {
    private Spinner spinner;
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected int oldValue;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private int increment = 1;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;
    private String errorMessage;
    private int validateStrategy = 0;

    public SpinnerFieldEditor(String name, String labelText, int width, Composite parent) {
        this.init(name, labelText);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"IntegerFieldEditor.errorMessage");
        this.widthInChars = width;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.spinner.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = false;
    }

    protected boolean checkState() {
        block4: {
            if (this.spinner == null) {
                return false;
            }
            String numberString = this.spinner.getText();
            try {
                int number = Integer.valueOf(numberString);
                if (number < this.minValue || number > this.maxValue) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.spinner = this.getSpinnerControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.spinner);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.spinner.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.spinner != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.spinner.setSelection(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.spinner != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.spinner.setSelection(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.spinner.getSelection());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public int getIntValue() {
        if (this.spinner != null) {
            return this.spinner.getSelection();
        }
        return this.getPreferenceStore().getInt(this.getPreferenceName());
    }

    protected Spinner getSpinnerControl() {
        return this.spinner;
    }

    public Spinner getSpinnerControl(Composite parent) {
        if (this.spinner == null) {
            this.spinner = new Spinner(parent, 2052);
            this.spinner.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.spinner.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            SpinnerFieldEditor.this.valueChanged();
                        }
                    });
                    this.spinner.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            SpinnerFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.spinner.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            SpinnerFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.spinner.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            SpinnerFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            SpinnerFieldEditor.this.valueChanged();
                            SpinnerFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.spinner.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SpinnerFieldEditor.this.spinner = null;
                }
            });
            if (this.textLimit > 0) {
                this.spinner.setTextLimit(this.textLimit);
            }
            this.spinner.setIncrement(this.getIncrement());
            this.spinner.setMinimum(this.getMinValue());
            this.spinner.setMaximum(this.getMaxValue());
        } else {
            this.checkParent((Control)this.spinner, parent);
        }
        return this.spinner;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.spinner != null) {
            this.spinner.setFocus();
        }
    }

    public void setIntValue(int value) {
        if (this.spinner != null) {
            if (this.spinner == null) {
                value = 0;
            }
            this.oldValue = this.spinner.getSelection();
            if (this.oldValue != value) {
                this.spinner.setSelection(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.spinner != null) {
            this.spinner.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        int newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if ((newValue = this.spinner.getSelection()) != this.oldValue) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getSpinnerControl(parent).setEnabled(enabled);
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setValidRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        this.setErrorMessage(JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{new Integer(min), new Integer(max)}));
    }
}

