/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse.preferences;

import io.emmet.eclipse.EclipseEmmetPlugin;
import io.emmet.eclipse.preferences.output.OutputProfile;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        store.setDefault("tabExpand", true);
        store.setDefault("tabExtensions", "html, xml, xsl, xsd, css, php, tpl, less, styl, scss, sass, jade, haml, hbs, twig");
        this.setupDefaultOutputProfiles();
    }

    private void setupDefaultOutputProfiles() {
        OutputProfile html = new OutputProfile();
        OutputProfile xml = new OutputProfile();
        xml.setTagCase("leave");
        xml.setAttrCase("leave");
        xml.setTagNewline("true");
        xml.setSelfClosing("true");
        this.setupOutputPrefrences("default", html);
        this.setupOutputPrefrences("html", html);
        this.setupOutputPrefrences("css", html);
        html.setFilters("haml");
        this.setupOutputPrefrences("haml", html);
        this.setupOutputPrefrences("xml", xml);
        xml.setFilters("html, xsl");
        this.setupOutputPrefrences("xsl", xml);
    }

    private void setupOutputPrefrences(String suffix, OutputProfile profile) {
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        store.setDefault(PreferenceInitializer.getPrefName("profileTagCase", suffix), profile.getTagCase());
        store.setDefault(PreferenceInitializer.getPrefName("profileAttrCase", suffix), profile.getAttrCase());
        store.setDefault(PreferenceInitializer.getPrefName("profileAttrQuotes", suffix), profile.getAttrQuotes());
        store.setDefault(PreferenceInitializer.getPrefName("profileTagNewline", suffix), profile.getTagNewline());
        store.setDefault(PreferenceInitializer.getPrefName("profilePlaceCursor", suffix), profile.isPlaceCaret());
        store.setDefault(PreferenceInitializer.getPrefName("profileIndent", suffix), profile.isIndentTags());
        store.setDefault(PreferenceInitializer.getPrefName("profileInlineBreak", suffix), profile.getInlineBreak());
        store.setDefault(PreferenceInitializer.getPrefName("profileSelfClosingTag", suffix), profile.getSelfClosing());
        store.setDefault(PreferenceInitializer.getPrefName("filters", suffix), profile.getFilters());
    }

    public static String getPrefName(String prefix, String suffix) {
        return String.valueOf(prefix) + "_" + suffix;
    }
}

