/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import java.util.ArrayList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AutoCompleteDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private Button okButton;
    private Text text;
    private int maxProposals = 10;
    private ArrayList<String> proposals;

    public AutoCompleteDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.setProposals(new ArrayList<String>());
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.text = new Text(composite, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        if (this.proposals != null) {
            try {
                String[] props = new String[Math.min(this.maxProposals, this.getProposals().size())];
                props = this.getProposals().subList(0, props.length).toArray(props);
                SimpleContentProposalProvider provider = new SimpleContentProposalProvider(props);
                provider.setFiltering(true);
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)provider, KeyStroke.getInstance((String)"ARROW_DOWN"), null);
                adapter.setProposalAcceptanceStyle(2);
                composite.pack();
                adapter.setPopupSize(new Point(this.text.getBounds().width, 100));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        AutoCompleteDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    protected int getShellStyle() {
        return 0x10010860 | AutoCompleteDialog.getDefaultOrientation();
    }

    public void setMaxProposals(int maxProposals) {
        this.maxProposals = maxProposals;
    }

    public int getMaxProposals() {
        return this.maxProposals;
    }

    public void setProposals(ArrayList<String> proposals) {
        this.proposals = proposals;
    }

    public ArrayList<String> getProposals() {
        return this.proposals;
    }
}

