/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core.utils;

import com.aptana.core.logging.IdeLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ZipUtils;
import com.pandora.pack.core.PackActivator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class PrimaryConfusionUtils {
    public static final String JSON_CONFUSION = "confusion";
    public static final String JSON_CONFUSION_RESOURCE = "resources";
    public static final String CONFUSION_FILE = "unpackage/.confusion";

    public static void recordConfusionFiles(HMobileProject project, List<IFile> files) throws IOException {
        if (project == null) {
            return;
        }
        JsonObject json = new JsonObject();
        if (files != null && !files.isEmpty()) {
            for (IFile file : files) {
                json.add(file.getProjectRelativePath().toString(), (JsonElement)new JsonObject());
            }
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String configJson = gson.toJson((JsonElement)json);
        FileUtils.write((File)project.getProject().getFile((IPath)new Path(CONFUSION_FILE)).getLocation().toFile(), (CharSequence)configJson, (String)"utf-8");
    }

    public static List<IFile> getConfusionFiles(HMobileProject hmobileProject) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            JsonObject json = PrimaryConfusionUtils.getConfusionJson(hmobileProject);
            if (json != null) {
                for (Map.Entry entry : json.entrySet()) {
                    IFile file = hmobileProject.getProject().getFile((IPath)new Path((String)entry.getKey()));
                    if (file == null || !file.exists() || file.getType() != 1) continue;
                    files.add(file);
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
        return files;
    }

    private static JsonObject getConfusionJson(HMobileProject hmobileProject) {
        if (hmobileProject == null) {
            return null;
        }
        IProject project = hmobileProject.getProject();
        IFile confusionFile = project.getFile((IPath)new Path(CONFUSION_FILE));
        if (!confusionFile.getLocation().toFile().exists()) {
            return null;
        }
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            return (JsonObject)gson.fromJson(FileUtils.readFileToString((File)confusionFile.getLocation().toFile(), (String)"utf-8"), JsonObject.class);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static boolean addConfusionInfo2Target(HMobileProject hmobileProject, File toConfusionResource, JsonObject targetJsonObject) {
        JsonObject resourcesJsonObject;
        if (targetJsonObject == null || hmobileProject == null || toConfusionResource == null || !toConfusionResource.exists()) {
            return false;
        }
        JsonObject plus = targetJsonObject.getAsJsonObject("plus");
        if (plus != null) {
            plus.remove(JSON_CONFUSION);
        }
        if ((resourcesJsonObject = PrimaryConfusionUtils.getConfusionJson(hmobileProject)) != null) {
            Iterator iterator = resourcesJsonObject.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                File file = new File(toConfusionResource, (String)entry.getKey());
                if (file.exists() && file.isFile()) continue;
                iterator.remove();
            }
            JsonObject confusionJsonObject = new JsonObject();
            confusionJsonObject.add(JSON_CONFUSION_RESOURCE, (JsonElement)resourcesJsonObject);
            if (plus == null) {
                plus = new JsonObject();
                targetJsonObject.add("plus", (JsonElement)plus);
            }
            plus.add(JSON_CONFUSION, (JsonElement)confusionJsonObject);
            plus.addProperty("runmode", "liberate");
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static void sent2CloudForConfusion(HMobileProject hmobileProject, File toConfusionResource, IProgressMonitor monitor) throws CoreException {
        if (hmobileProject == null || toConfusionResource == null || !toConfusionResource.exists() || monitor.isCanceled()) {
            return;
        }
        monitor.beginTask("\u5411\u4e91\u7aef\u8bf7\u6c42js\u539f\u751f\u6df7\u6dc6", 4);
        monitor.subTask("\u51c6\u5907\u6df7\u6dc6\u8d44\u6e90");
        JsonObject resourcesJsonObject = PrimaryConfusionUtils.getConfusionJson(hmobileProject);
        if (monitor.isCanceled()) {
            return;
        }
        if (resourcesJsonObject != null) {
            File tmp;
            block43: {
                File downloadDir;
                String appid;
                block47: {
                    File downloadFile;
                    block46: {
                        ResponseObj responseObj;
                        block45: {
                            File wgtFile;
                            block44: {
                                JsonObject appConfigJson;
                                Gson gson;
                                boolean hasFile2Confusion;
                                File appidDir;
                                block42: {
                                    appid = hmobileProject.getAppid();
                                    tmp = PackActivator.getDefault().getBundle().getDataFile(".tmp" + System.currentTimeMillis());
                                    try {
                                        tmp.mkdirs();
                                        appidDir = new File(tmp, "zip/" + appid);
                                        hasFile2Confusion = false;
                                        gson = new GsonBuilder().disableHtmlEscaping().create();
                                        appConfigJson = null;
                                        try {
                                            appConfigJson = (JsonObject)gson.fromJson(FileUtils.readFileToString((File)new File(toConfusionResource, "manifest.json"), (String)"utf-8"), JsonObject.class);
                                        }
                                        catch (JsonSyntaxException e) {
                                            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "manifest.json\u6587\u4ef6\u8bed\u6cd5\u8bed\u6cd5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Throwable)e));
                                        }
                                        catch (IOException e) {
                                            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u672c\u5730\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + e.getMessage(), (Throwable)e));
                                        }
                                        Iterator iterator = resourcesJsonObject.entrySet().iterator();
                                        while (iterator.hasNext()) {
                                            Map.Entry entry = (Map.Entry)iterator.next();
                                            File file = new File(toConfusionResource, (String)entry.getKey());
                                            if (file.exists() && file.isFile()) {
                                                try {
                                                    FileUtils.copyFile((File)file, (File)new File(appidDir, (String)entry.getKey()));
                                                }
                                                catch (IOException e) {
                                                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                                    throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u672c\u5730\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + e.getMessage(), (Throwable)e));
                                                }
                                                hasFile2Confusion = true;
                                                continue;
                                            }
                                            iterator.remove();
                                        }
                                        if (!monitor.isCanceled()) break block42;
                                    }
                                    catch (Throwable throwable) {
                                        monitor.done();
                                        try {
                                            FileUtils.deleteDirectory((File)tmp);
                                        }
                                        catch (Exception exception) {}
                                        throw throwable;
                                    }
                                    monitor.done();
                                    try {
                                        FileUtils.deleteDirectory((File)tmp);
                                    }
                                    catch (Exception exception) {}
                                    return;
                                }
                                if (!hasFile2Confusion) break block43;
                                JsonObject plus = appConfigJson.getAsJsonObject("plus");
                                if (plus != null) {
                                    plus.remove(JSON_CONFUSION);
                                }
                                appConfigJson.remove("dependencies");
                                appConfigJson.remove("unpackage");
                                if (plus == null) {
                                    plus = new JsonObject();
                                    appConfigJson.add("plus", (JsonElement)plus);
                                }
                                JsonObject confusionJsonObject = new JsonObject();
                                confusionJsonObject.add(JSON_CONFUSION_RESOURCE, (JsonElement)resourcesJsonObject);
                                plus.add(JSON_CONFUSION, (JsonElement)confusionJsonObject);
                                wgtFile = new File(tmp, String.valueOf(appid) + ".wgt");
                                try {
                                    FileUtils.writeStringToFile((File)new File(appidDir, "manifest.json"), (String)gson.toJson((JsonElement)appConfigJson), (String)"utf-8");
                                    monitor.worked(1);
                                    monitor.subTask("\u538b\u7f29\u6df7\u6dc6\u8d44\u6e90");
                                    ZipUtils.zip((String)appidDir.getParent(), (String)wgtFile.getAbsolutePath());
                                }
                                catch (IOException e) {
                                    throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u672c\u5730\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + e.getMessage(), (Throwable)e));
                                }
                                monitor.worked(1);
                                if (!monitor.isCanceled()) break block44;
                                monitor.done();
                                try {
                                    FileUtils.deleteDirectory((File)tmp);
                                }
                                catch (Exception exception) {}
                                return;
                            }
                            monitor.subTask("\u5411\u4e91\u7aef\u53d1\u9001\u8bf7\u6c42");
                            HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!confusionWgt");
                            httpClientUtils.addRequestBody("appid", appid);
                            httpClientUtils.addRequestBody("appname", hmobileProject.getProject().getName());
                            httpClientUtils.addFileBody("attachment", wgtFile);
                            downloadFile = new File(tmp, "download.wgt");
                            responseObj = httpClientUtils.excuteDownloadPost(null, null, downloadFile, false, true);
                            monitor.worked(1);
                            if (!monitor.isCanceled()) break block45;
                            monitor.done();
                            try {
                                FileUtils.deleteDirectory((File)tmp);
                            }
                            catch (Exception exception) {}
                            return;
                        }
                        if (responseObj.isConnectionError()) {
                            if (!monitor.isCanceled()) {
                                if (responseObj.getHttpErrorCode() >= 500) {
                                    throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "js\u539f\u751f\u6df7\u6dc6\u9700\u8981\u5c06\u8d44\u6e90\u63d0\u4ea4\u5230\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u4e91\u7aef\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                                }
                                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "js\u539f\u751f\u6df7\u6dc6\u9700\u8981\u5c06\u8d44\u6e90\u63d0\u4ea4\u5230\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc"));
                            }
                            break block43;
                        }
                        if (!"1001".equals(responseObj.getRspcode())) {
                            String error = responseObj.getRspdesc();
                            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", Integer.parseInt(responseObj.getRspcode()), error, null));
                        }
                        if (!responseObj.isOk()) break block43;
                        if (!monitor.isCanceled()) break block46;
                        monitor.done();
                        try {
                            FileUtils.deleteDirectory((File)tmp);
                        }
                        catch (Exception exception) {}
                        return;
                    }
                    monitor.subTask("\u5904\u7406\u4e91\u7aef\u8fd4\u56de\u6570\u636e");
                    downloadDir = new File(tmp, "download");
                    ZipUtils.unzip((String)downloadFile.getAbsolutePath(), (String)downloadDir.getAbsolutePath());
                    if (!monitor.isCanceled()) break block47;
                    monitor.done();
                    try {
                        FileUtils.deleteDirectory((File)tmp);
                    }
                    catch (Exception exception) {}
                    return;
                }
                FileUtils.copyDirectory((File)new File(downloadDir, appid), (File)toConfusionResource);
                break block43;
                {
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u672c\u5730\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + e.getMessage(), (Throwable)e));
                    }
                }
            }
            monitor.done();
            try {
                FileUtils.deleteDirectory((File)tmp);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean needConfusionFeature() {
        return true;
    }
}

