/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core.utils;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.URIUtil;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.pack.core.PackActivator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ExploreFile {
    public static IStatus exploreDownload(String projectName, boolean isDebug) {
        return ExploreFile.exploreDownload(projectName, null, isDebug);
    }

    public static IStatus exploreDownload(String projectName, String fileName, boolean isDebug) {
        try {
            File f = ExploreFile.getDownloadPathFile(projectName, fileName, isDebug);
            if (f != null && f.exists()) {
                URIUtil.open((URI)f.toURI());
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
            return new Status(4, "com.pandora.pack.core", e.getMessage(), (Throwable)e);
        }
    }

    public static File getDownloadPathFile(String projectName, String fileName, boolean isDebug) throws IOException, CoreException {
        IFolder download = ResourceUtil.getAppProjectUnPackageDir((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), (String)(isDebug ? "debug" : "release"), (String[])new String[0]);
        File f = null;
        f = fileName == null ? new File(download.getLocation().toString()) : new File(download.getLocation().toString(), fileName);
        return f;
    }
}

