/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core;

import com.aptana.core.logging.IdeLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pandora.core.appstream.AppStream;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.IFileUpdateProgress;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.android.AndroidIcon;
import com.pandora.core.mobile.model.android.AndroidSplashScreen;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.ZipUtils;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeService;
import com.pandora.pack.core.AppOwnerException;
import com.pandora.pack.core.MakePackage;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class PublishStreamApp {
    public static final int CODE_SIZE = 99;
    protected HMobileProject project;
    protected String appid;
    protected boolean isWap2app;
    protected boolean isWeapp;
    protected ManifastConfiguration appConfig;

    public PublishStreamApp(HMobileProject project, ManifastConfiguration appConfig) throws CoreException {
        this.project = project;
        this.appConfig = project.getAppConfig();
        this.appid = appConfig.getAppid();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String configJson = gson.toJson((Object)appConfig);
        this.appConfig = (ManifastConfiguration)gson.fromJson(configJson, ManifastConfiguration.class);
        this.isWap2app = project.getProject().hasNature("com.pandora.projects.ui.Wap2AppNature");
        this.isWeapp = project.getProject().hasNature("com.pandora.projects.ui.WechatNature");
    }

    @Deprecated
    public PublishStreamApp(String appid) throws CoreException {
        this.appid = this.appConfig.getAppid();
    }

    public JSONObject publish2TestPlatform(int upmode, Runnable cannotCancelNotify, boolean needConfusion, IProgressMonitor monitor) throws CoreException {
        return this.publish2TestPlatform(upmode, null, cannotCancelNotify, needConfusion, true, "HBuilder " + ProductUtils.getProductVersion(), monitor);
    }

    public JSONObject publish2TestPlatform(int upmode, List<File> zips, Runnable cannotCancelNotify, boolean needConfusion, boolean check, String channel, IProgressMonitor monitor) throws CoreException {
        JSONObject jSONObject;
        JSONObject json;
        Job stopJob;
        File zip;
        block36: {
            block35: {
                zip = null;
                stopJob = null;
                if (!monitor.isCanceled()) break block35;
                if (!Platform.inDevelopmentMode()) {
                    FileUtils.deleteQuietly(zip);
                }
                if (stopJob != null) {
                    try {
                        stopJob.cancel();
                    }
                    catch (Throwable throwable) {}
                }
                return null;
            }
            if (check) {
                monitor.subTask("\u6743\u9650\u9a8c\u8bc1");
                PublishStreamApp.checkAppOwner(monitor, this.appid, this.appConfig.getAppName());
            }
            monitor.worked(1);
            Thread.sleep(100L);
            monitor.subTask("\u538b\u7f29\u76f8\u5173\u8d44\u6e90");
            try {
                zip = this.zipPackage(zips, needConfusion, check);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u538b\u7f29\u8d44\u6e90\u4ee3\u7801\u8d44\u6e90\u5931\u8d25"));
            }
            IdeLog.logError((Plugin)PackActivator.getDefault(), (String)("zip\u6587\u4ef6: " + zip));
            monitor.worked(1);
            Thread.sleep(100L);
            monitor.subTask("\u63d0\u4ea4\u4ee3\u7801\u5230\u6d41\u5e94\u7528\u6d4b\u8bd5\u5e73\u53f0");
            HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"StreamApp!publish");
            httpClientUtils.setSoTimeout(150000);
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("email", UserAuth.getUsername());
            request.put("appid", this.appid);
            request.put("appname", this.appConfig.getAppName());
            request.put("version", this.appConfig.getVersion().getName());
            request.put("__am", "t");
            request.put("url", "");
            request.put("summary", this.appConfig.getDescription() == null ? "" : this.appConfig.getDescription());
            request.put("sortindex", "");
            request.put("channel", channel);
            if (upmode >= 0) {
                request.put("up_mode", upmode);
            }
            if (this.isWeapp) {
                request.put("app_type", "WEAPP");
            } else if (this.isWap2app) {
                request.put("app_type", "WAP2APP");
            } else {
                request.put("app_type", "STREAM");
            }
            httpClientUtils.addRequestBody(request);
            final long[] uploadProgress = new long[2];
            httpClientUtils.addFileBody("app", zip, new IFileUpdateProgress(){

                public void update(long contentLength, long progress) {
                    uploadProgress[0] = progress;
                    uploadProgress[1] = contentLength;
                }
            });
            BasicHttpContext httpContext = new BasicHttpContext();
            HttpPost httpPost = httpClientUtils.createHttpPost();
            stopJob = new Job("stop or statistic Package upload job", (HttpContext)httpContext, cannotCancelNotify, monitor, httpPost, uploadProgress){
                private int statisticsUploadSpeedNumber;
                private long lastStatisticUploadSpeedSize;
                private long lastStatisticUploadSpeedTime;
                private double lastUploadProgress;
                private final /* synthetic */ HttpContext val$httpContext;
                private final /* synthetic */ Runnable val$cannotCancelNotify;
                private final /* synthetic */ IProgressMonitor val$monitor;
                private final /* synthetic */ HttpPost val$httpPost;
                private final /* synthetic */ long[] val$uploadProgress;
                {
                    this.val$httpContext = httpContext;
                    this.val$cannotCancelNotify = runnable;
                    this.val$monitor = iProgressMonitor;
                    this.val$httpPost = httpPost;
                    this.val$uploadProgress = lArray;
                    super($anonymous0);
                    this.statisticsUploadSpeedNumber = 0;
                    this.lastStatisticUploadSpeedSize = 0L;
                    this.lastStatisticUploadSpeedTime = 0L;
                    this.lastUploadProgress = 0.0;
                }

                protected IStatus run(IProgressMonitor subMonitor) {
                    IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u5f00\u59cb\u4e0a\u4f20");
                    while (!subMonitor.isCanceled()) {
                        Object hasSent = this.val$httpContext.getAttribute("http.request_sent");
                        if (this.val$cannotCancelNotify != null && hasSent != null && hasSent instanceof Boolean && ((Boolean)hasSent).booleanValue()) {
                            try {
                                this.val$cannotCancelNotify.run();
                                this.updateUploadProgress();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u4e0a\u4f20\u5b8c\u6210, \u7981\u6b62\u53d6\u6d88\u4e0a\u4f20");
                                this.val$monitor.subTask("\u6536\u53d6\u6d41\u5e94\u7528\u6d4b\u8bd5\u5e73\u53f0\u8bf7\u6c42\u54cd\u5e94\u6570\u636e");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        if (this.val$monitor.isCanceled()) {
                            if (this.val$httpPost.isAborted()) break;
                            try {
                                this.val$httpPost.abort();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u53d6\u6d88\u4e0a\u4f20");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        this.updateUploadProgress();
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return Status.OK_STATUS;
                }

                private void updateUploadProgress() {
                    try {
                        double now;
                        double add;
                        ++this.statisticsUploadSpeedNumber;
                        long progress = this.val$uploadProgress[0];
                        long contentLength = this.val$uploadProgress[1];
                        if (progress != 0L && contentLength != 0L && (add = (now = (double)progress * 1.0 / (double)contentLength * 89.0) - this.lastUploadProgress) >= 1.0) {
                            this.lastUploadProgress = now;
                            this.val$monitor.internalWorked(add);
                        }
                        if (this.statisticsUploadSpeedNumber == 1) {
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                            this.lastStatisticUploadSpeedSize = progress;
                        }
                        if (this.statisticsUploadSpeedNumber % 5 == 0) {
                            this.val$monitor.subTask(String.format("\u5411\u6d41\u5e94\u7528\u6d4b\u8bd5\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42   (%.2fK/s)", (double)(progress - this.lastStatisticUploadSpeedSize) / (1024.0 * ((double)(System.currentTimeMillis() - this.lastStatisticUploadSpeedTime) / 1000.0))));
                            this.lastStatisticUploadSpeedSize = progress;
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                    }
                }
            };
            stopJob.setSystem(true);
            stopJob.schedule();
            long start = System.currentTimeMillis();
            ResponseObj responseObj = httpClientUtils.excute((HttpContext)httpContext, httpPost, false, false);
            if (Platform.inDevelopmentMode()) {
                System.out.println("\u4e0a\u4f20\u8017\u65f6: " + (System.currentTimeMillis() - start));
            }
            stopJob.cancel();
            monitor.worked(1);
            if (responseObj.isConnectionError()) {
                if (responseObj.getHttpErrorCode() >= 500) {
                    throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u6d41\u5e94\u7528\u6d4b\u8bd5\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                }
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u65e0\u6cd5\u8fde\u63a5\u5230\u6d41\u5e94\u7528\u6d4b\u8bd5\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc"));
            }
            json = (JSONObject)responseObj.getBody();
            int ret = json.optInt("ret");
            if (ret == 0) break block36;
            if (!monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", json.optString("desc")));
            }
            stopJob.cancel();
            if (!Platform.inDevelopmentMode()) {
                FileUtils.deleteQuietly((File)zip);
            }
            if (stopJob != null) {
                try {
                    stopJob.cancel();
                }
                catch (Throwable throwable) {}
            }
            return null;
        }
        try {
            monitor.subTask("\u63d0\u4ea4\u4ee3\u7801\u5230\u6d41\u5e94\u7528\u6d4b\u8bd5\u5e73\u53f0\u6210\u529f");
            jSONObject = json;
        }
        catch (Exception e) {
            try {
                if (e instanceof CoreException) {
                    throw (CoreException)e;
                }
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", e.getMessage(), (Throwable)e));
            }
            catch (Throwable throwable) {
                if (!Platform.inDevelopmentMode()) {
                    FileUtils.deleteQuietly(zip);
                }
                if (stopJob != null) {
                    try {
                        stopJob.cancel();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
        }
        if (!Platform.inDevelopmentMode()) {
            FileUtils.deleteQuietly((File)zip);
        }
        if (stopJob != null) {
            try {
                stopJob.cancel();
            }
            catch (Throwable throwable) {}
        }
        return jSONObject;
    }

    public JSONObject publish2ReleasePlatform(String releaseVersion, String testVersion, String notes, int upmode, IProgressMonitor monitor) throws CoreException {
        return this.publish2ReleasePlatform(releaseVersion, testVersion, notes, upmode, true, monitor);
    }

    public JSONObject publish2ReleasePlatform(String releaseVersion, String testVersion, String notes, int upmode, boolean check, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("\u6743\u9650\u9a8c\u8bc1");
        if (check) {
            PublishStreamApp.checkAppOwner(monitor, this.appid, this.appConfig.getAppName());
        }
        monitor.worked(1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        monitor.subTask("\u5411\u5e73\u53f0\u7533\u8bf7\u53d1\u5e03\u4e3a\u6b63\u5f0f");
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"StreamApp!release");
        httpClientUtils.setSoTimeout(150000);
        httpClientUtils.addRequestBody("email", UserAuth.getUsername());
        httpClientUtils.addRequestBody("appid", this.appid);
        httpClientUtils.addRequestBody("rv", releaseVersion);
        httpClientUtils.addRequestBody("tv", testVersion);
        httpClientUtils.addRequestBody("notes", notes);
        httpClientUtils.addRequestBody("channel", "HBuilder " + ProductUtils.getProductVersion());
        if (upmode >= 0) {
            httpClientUtils.addRequestBody("up_mode", (Object)upmode);
        }
        if (this.isWeapp) {
            httpClientUtils.addRequestBody("app_type", "WEAPP");
        }
        ResponseObj responseObj = httpClientUtils.excute(false, false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        monitor.worked(1);
        if (responseObj.isConnectionError()) {
            if (responseObj.getHttpErrorCode() >= 500) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u6d41\u5e94\u7528\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u65e0\u6cd5\u8fde\u63a5\u5230\u6d41\u5e94\u7528\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc"));
        }
        JSONObject json = (JSONObject)responseObj.getBody();
        int ret = json.optInt("ret");
        if (ret != 0) {
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", json.optString("desc")));
        }
        return json;
    }

    public static void checkAppOwner(IProgressMonitor monitor, String appid, String appName) throws CoreException {
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"StreamApp!checkowner");
        httpClientUtils.addRequestBody("email", UserAuth.getUsername());
        httpClientUtils.addRequestBody("appid", appid);
        httpClientUtils.addRequestBody("appname", appName);
        ResponseObj responseObj = httpClientUtils.excuteGet();
        if (responseObj.isConnectionError()) {
            if (responseObj.getHttpErrorCode() >= 500) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u6d41\u5e94\u7528\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u65e0\u6cd5\u8fde\u63a5\u5230\u6d41\u5e94\u7528\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc"));
        }
        JSONObject json = (JSONObject)responseObj.getBody();
        boolean result = json.optBoolean("check");
        String ownEmail = json.optString("email");
        if (!result) {
            monitor.worked(10);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            throw new AppOwnerException((IStatus)new Status(4, "com.pandora.pack.core", ownEmail));
        }
    }

    public File zipPackage(List<File> zips, boolean needConfusion, boolean checkIndexSize) throws IOException, CoreException {
        File tmp = PackActivator.getDefault().getBundle().getDataFile(".tmp" + System.currentTimeMillis());
        File projectDir = new File(this.project.getProject().getLocationURI());
        try {
            this.readyToZip(needConfusion, tmp, projectDir);
            if (checkIndexSize && this.computesIndexSize(tmp, null) > 150L) {
                final boolean[] ok = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ok[0] = new MessageDialog(Display.getDefault().getActiveShell(), "\u63d0\u793a", null, "\u5165\u53e3\u9875\u9762\u5f15\u7528\u7684\u8d44\u6e90\u6587\u4ef6\u8d85\u8fc7150KB\uff0c\u662f\u5426\u9700\u8981\u4f18\u5316", 1, new String[]{"\u7acb\u5373\u4f18\u5316", "\u5ffd\u7565\u5e76\u7ee7\u7eed"}, 0).open() == 0;
                    }
                });
                if (ok[0]) {
                    throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", 99, null, null));
                }
            }
            File zip = PackActivator.getDefault().getBundle().getDataFile(String.valueOf(this.appid) + ".zip");
            if (zips != null && !zips.isEmpty()) {
                for (File file : zips) {
                    if (file == null || !file.exists()) continue;
                    FileUtils.copyFileToDirectory((File)file, (File)tmp);
                }
            }
            ZipUtils.zip((String)tmp.getAbsolutePath(), (String)zip.getAbsolutePath());
            IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("ZIP\u9879\u76ee{0} \u7ed3\u675f: {1}", projectDir, zip));
            File file = zip;
            return file;
        }
        finally {
            if (tmp.exists()) {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
    }

    public void readyToZip(boolean needConfusion, File tmp, File projectDir) throws IOException, CoreException {
        this.readyToZip(true, needConfusion, true, tmp, projectDir);
    }

    public void readyToZip(boolean createAppstreeam, boolean needConfusion, boolean checkError, File tmp, File projectDir) throws IOException, CoreException {
        AndroidSplashScreen androidSplashScreen;
        File wap2Appconfig;
        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u5f00\u59cbZIP\u9879\u76ee: {0}", projectDir));
        File oldTmp = PackActivator.getDefault().getBundle().getDataFile(".tmp");
        if (oldTmp.exists()) {
            FileUtils.deleteQuietly((File)oldTmp);
        }
        if (tmp.exists()) {
            FileUtils.deleteQuietly((File)tmp);
        }
        tmp.mkdirs();
        JsonObject appConfigJson = ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)this.appConfig, (File)new File(projectDir, "manifest.json"), (IProject)this.project.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)true, (boolean)false);
        File wwwDir = new File(tmp, "www");
        MakePackage.copyPackAgeResources(this.project, needConfusion, checkError, projectDir, wwwDir, appConfigJson);
        if (createAppstreeam) {
            File appStreamFile = new File(wwwDir, "appstream.json");
            appStreamFile.delete();
            File streamFile = new File(tmp, "appstream.json");
            try {
                new AppStreamFileBuilder().buildFromManiFest(this.project, streamFile);
            }
            catch (RuntimeException e) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u751f\u6210\u9875\u9762\u5f15\u7528\u5173\u7cfb\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + e.getMessage(), (Throwable)e));
            }
        }
        if (this.isWap2app && (wap2Appconfig = new File(wwwDir, "__wap2appconfig.js")).exists()) {
            try {
                String text = NodeService.compressor((JSONObject)new JSONObject(), (ContentType)ContentType.JS, (String)FileUtils.readFileToString((File)wap2Appconfig, (String)"utf-8"));
                FileUtils.write((File)wap2Appconfig, (CharSequence)text, (String)"utf-8");
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
            }
        }
        File icons = new File(tmp, "icons");
        File splash = new File(tmp, "splash");
        AndroidIcon androidIcon = this.appConfig.getPlus().getDistribute().getIcons().getAndroid();
        if (androidIcon != null) {
            JsonObject androidIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("android");
            String filname = this.copyFile(androidIcon.getLdpi(), "icon48", icons);
            if (filname != null) {
                androidIconJson.addProperty("ldpi", filname);
            } else {
                filname = this.copyFile(androidIcon.getMdpi(), "icon48", icons);
                if (filname != null) {
                    androidIconJson.addProperty("mdpi", filname);
                }
            }
            filname = this.copyFile(androidIcon.getHdpi(), "icon72", icons);
            if (filname != null) {
                androidIconJson.addProperty("hdpi", filname);
            }
            if ((filname = this.copyFile(androidIcon.getXhdpi(), "icon96", icons)) != null) {
                androidIconJson.addProperty("xhdpi", filname);
            }
            if ((filname = this.copyFile(androidIcon.getXxhdpi(), "icon144", icons)) != null) {
                androidIconJson.addProperty("xxhdpi", filname);
            }
            if ((filname = this.copyFile(androidIcon.getXxxhdpi(), "icon192", icons)) != null) {
                androidIconJson.addProperty("xxxhdpi", filname);
            }
            this.copyFile(androidIcon.getHdpi(), "default", icons);
            File icon256 = ResourceUtil.getAppProjectResDir((IProject)this.project.getProject(), (String[])new String[]{"icons"}).getFile("256x256.png").getLocation().toFile();
            if (icon256.exists()) {
                this.copyFile(icon256.getAbsolutePath(), "icon256", icons);
            }
        }
        if ((androidSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getAndroid()) != null) {
            JsonObject androidSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("android");
            String filname = this.copyFile(androidSplashScreen.getLdpi(), "ldpi", splash);
            if (filname != null) {
                androidSplashScreenJson.addProperty("ldpi", filname);
            }
            if ((filname = this.copyFile(androidSplashScreen.getMdpi(), "mdpi", splash)) != null) {
                androidSplashScreenJson.addProperty("mdpi", filname);
            }
            if ((filname = this.copyFile(androidSplashScreen.getHdpi(), "hdpi", splash)) != null) {
                androidSplashScreenJson.addProperty("hdpi", filname);
            }
            if ((filname = this.copyFile(androidSplashScreen.getXhdpi(), "xhdpi", splash)) != null) {
                androidSplashScreenJson.addProperty("xhdpi", filname);
            }
            if ((filname = this.copyFile(androidSplashScreen.getXxhdpi(), "xxhdpi", splash)) != null) {
                androidSplashScreenJson.addProperty("xxhdpi", filname);
            }
            this.copyFile(androidSplashScreen.getXhdpi(), "default", splash);
        }
        if (needConfusion) {
            PrimaryConfusionUtils.addConfusionInfo2Target(this.project, wwwDir, appConfigJson);
        } else {
            appConfigJson.remove("confusion");
        }
        appConfigJson.remove("unpackage");
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        if (appConfigJson.has("plus")) {
            JsonObject plus = appConfigJson.getAsJsonObject("plus");
            plus.remove("distribute");
        }
        if (appConfigJson.has("dependencies")) {
            appConfigJson.remove("dependencies");
        }
        String configJson = gson.toJson((JsonElement)appConfigJson);
        FileUtils.write((File)new File(wwwDir, "manifest.json"), (CharSequence)configJson, (String)"utf-8");
    }

    private long computesIndexSize(File tmp, final Set<File> indexResourcesCollector) throws IOException, CoreException {
        long size = 0L;
        File indexZip = PackActivator.getDefault().getBundle().getDataFile(String.valueOf(this.appid) + "_index" + ".zip");
        try {
            File wwwDir = new File(tmp, "www");
            File streamFile = new File(tmp, "appstream.json");
            if (streamFile.exists()) {
                String streamContent = FileUtils.readFileToString((File)streamFile);
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                AppStream appStream = (AppStream)gson.fromJson(streamContent, AppStream.class);
                Object[] indexResources = appStream.getMain().getResources();
                final ArrayList indexResourcesList = (ArrayList)CollectionsUtil.newList((Object[])indexResources);
                indexResourcesList.add(appStream.getMain().getHref());
                if (CollectionsUtil.isNotEmpty((Collection)indexResourcesList)) {
                    final int length = wwwDir.getAbsolutePath().length();
                    ZipUtils.zip((String)wwwDir.getAbsolutePath(), (String)indexZip.getAbsolutePath(), (FileFilter)new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String filePath = file.getAbsolutePath();
                            String tempFP = (filePath = filePath.substring(length + 1)).replace("\\", "/");
                            if (indexResourcesList.contains(tempFP) || indexResourcesList.contains(filePath)) {
                                if (indexResourcesCollector != null && file.isFile()) {
                                    indexResourcesCollector.add(file);
                                }
                                return true;
                            }
                            return false;
                        }
                    });
                    size = indexZip.length();
                }
            }
        }
        finally {
            indexZip.delete();
        }
        return size / 1024L;
    }

    protected String copyFile(String fileStr, String fileName, File dir) throws IOException {
        return MakePackage.copyFile(this.project.getProject(), fileStr, fileName, dir);
    }
}

