/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.IFileUpdateProgress;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.android.AndroidIcon;
import com.pandora.core.mobile.model.android.AndroidSplashScreen;
import com.pandora.core.mobile.model.android.GoogleProfile;
import com.pandora.core.mobile.model.ios.AppleProfile;
import com.pandora.core.mobile.model.ios.IOSIcon;
import com.pandora.core.mobile.model.ios.IPadIcon;
import com.pandora.core.mobile.model.ios.IPadSplashScreen;
import com.pandora.core.mobile.model.ios.IPhoneIcon;
import com.pandora.core.mobile.model.ios.IPhoneSplashScreen;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.project.IProjectProcessor;
import com.pandora.core.project.ProjectProcessors;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.ZipUtils;
import com.pandora.pack.core.Messages;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.PackPlatform;
import com.pandora.pack.core.download.DownloadDataManager;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class MakePackage {
    protected static final String MANIFAST_DIR_NAME = ".manifest";
    protected static final String chineseRegEx = "[^\\x00-\\xff]";
    protected static final Pattern chinesePattern = Pattern.compile("[^\\x00-\\xff]");
    protected HMobileProject project;
    protected List<PackPlatform> phoneModules;
    protected String appid;
    protected ManifastConfiguration appConfig;
    private boolean debugMode;

    public MakePackage(HMobileProject project, ManifastConfiguration appConfig, List<PackPlatform> phoneModules, boolean debugMode) throws CoreException {
        this.phoneModules = phoneModules;
        this.project = project;
        this.appid = appConfig.getAppid();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String configJson = gson.toJson((Object)appConfig);
        this.appConfig = (ManifastConfiguration)gson.fromJson(configJson, ManifastConfiguration.class);
        this.debugMode = debugMode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject makePackage(Runnable cannotCancelNotify, boolean needConfusion, IProgressMonitor monitor) throws CoreException, IOException {
        JSONObject jSONObject;
        PackPlatform[] ps;
        ResponseObj responseObj;
        Job stopJob;
        block27: {
            File zip;
            block29: {
                block28: {
                    IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u5f00\u59cb\u6253\u5305\u9879\u76ee{0}", this.project));
                    monitor.subTask("\u538b\u7f29\u76f8\u5173\u8d44\u6e90");
                    for (PackPlatform packPlatform : this.phoneModules) {
                        if (packPlatform.equals((Object)PackPlatform.IOS_ADHOC) || packPlatform.equals((Object)PackPlatform.IOS_APPSTORE) || packPlatform.equals((Object)PackPlatform.IOS_PB)) {
                            Stats.addOperateInfo((String)"menu", (String)"TMIPI", null);
                            continue;
                        }
                        if (!packPlatform.equals((Object)PackPlatform.ANDROID_GOOGLEPLAY) && !packPlatform.equals((Object)PackPlatform.ANDROID_PB)) continue;
                        Stats.addOperateInfo((String)"menu", (String)"TMIPA", null);
                    }
                    zip = null;
                    stopJob = null;
                    if (monitor.isCanceled()) break block28;
                    zip = this.zipPackage(needConfusion);
                    if (!monitor.isCanceled()) break block29;
                }
                if (stopJob == null) return null;
                try {
                    stopJob.cancel();
                    return null;
                }
                catch (Throwable throwable) {}
                return null;
            }
            if (zip.length() > 0x2800000L) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "App\u5305\u5927\u5c0f\u4e0d\u53ef\u8d85\u8fc740M\uff0c\u5982\u9700\u6253\u8d85\u8fc740M\u7684App\u5305\uff0c\u8bf7\u4f7f\u7528\u672c\u5730\u6253\u5305\uff01"));
            }
            monitor.worked(10);
            monitor.subTask("\u5411\u4e91\u7aef\u53d1\u9001\u6253\u5305\u8bf7\u6c42");
            HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!generateAppPackage");
            HashMap<String, Object> request = new HashMap<String, Object>();
            List<String> platform = PackPlatform.toStrings(this.phoneModules);
            request.put("platform", platform);
            request.put("appid", this.appid);
            request.put("appname", this.appConfig.getAppName());
            if (ProductUtils.isAlpha()) {
                request.put("alpha", true);
            }
            httpClientUtils.addRequestBody(request);
            final long[] uploadProgress = new long[2];
            httpClientUtils.addFileBody("attachment", zip, new IFileUpdateProgress(){

                public void update(long contentLength, long progress) {
                    uploadProgress[0] = progress;
                    uploadProgress[1] = contentLength;
                }
            });
            IdeLog.logError((Plugin)PackActivator.getDefault(), (String)("zip\u6587\u4ef6: " + zip));
            IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u4e0a\u4f20\u6253\u5305\u6570\u636e appid:{0} platform:{1} file:{2}", this.appid, StringUtil.join((String)",", platform), zip));
            BasicHttpContext httpContext = new BasicHttpContext();
            HttpPost httpPost = httpClientUtils.createHttpPost();
            stopJob = new Job("stop or statistic Package upload job", (HttpContext)httpContext, cannotCancelNotify, monitor, httpPost, uploadProgress){
                private int statisticsUploadSpeedNumber;
                private long lastStatisticUploadSpeedSize;
                private long lastStatisticUploadSpeedTime;
                private double lastUploadProgress;
                private final /* synthetic */ HttpContext val$httpContext;
                private final /* synthetic */ Runnable val$cannotCancelNotify;
                private final /* synthetic */ IProgressMonitor val$monitor;
                private final /* synthetic */ HttpPost val$httpPost;
                private final /* synthetic */ long[] val$uploadProgress;
                {
                    this.val$httpContext = httpContext;
                    this.val$cannotCancelNotify = runnable;
                    this.val$monitor = iProgressMonitor;
                    this.val$httpPost = httpPost;
                    this.val$uploadProgress = lArray;
                    super($anonymous0);
                    this.statisticsUploadSpeedNumber = 0;
                    this.lastStatisticUploadSpeedSize = 0L;
                    this.lastStatisticUploadSpeedTime = 0L;
                    this.lastUploadProgress = 0.0;
                }

                protected IStatus run(IProgressMonitor subMonitor) {
                    IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u5f00\u59cb\u6253\u5305\u4e0a\u4f20");
                    while (!subMonitor.isCanceled()) {
                        Object hasSent = this.val$httpContext.getAttribute("http.request_sent");
                        if (this.val$cannotCancelNotify != null && hasSent != null && hasSent instanceof Boolean && ((Boolean)hasSent).booleanValue()) {
                            try {
                                this.val$cannotCancelNotify.run();
                                this.updateUploadProgress();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u6253\u5305\u4e0a\u4f20\u5b8c\u6210, \u7981\u6b62\u53d6\u6d88\u6253\u5305");
                                this.val$monitor.subTask("\u6536\u53d6\u4e91\u7aef\u6253\u5305\u8bf7\u6c42\u54cd\u5e94\u6570\u636e");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        if (this.val$monitor.isCanceled()) {
                            if (this.val$httpPost.isAborted()) break;
                            try {
                                this.val$httpPost.abort();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u53d6\u6d88\u6253\u5305\u4e0a\u4f20");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        this.updateUploadProgress();
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return Status.OK_STATUS;
                }

                private void updateUploadProgress() {
                    try {
                        double now;
                        double add;
                        ++this.statisticsUploadSpeedNumber;
                        long progress = this.val$uploadProgress[0];
                        long contentLength = this.val$uploadProgress[1];
                        if (progress != 0L && contentLength != 0L && (add = (now = (double)progress * 1.0 / (double)contentLength * 89.0) - this.lastUploadProgress) >= 1.0) {
                            this.lastUploadProgress = now;
                            this.val$monitor.internalWorked(add);
                        }
                        if (this.statisticsUploadSpeedNumber == 1) {
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                            this.lastStatisticUploadSpeedSize = progress;
                        }
                        if (this.statisticsUploadSpeedNumber % 5 == 0) {
                            this.val$monitor.subTask(String.format("\u5411\u4e91\u7aef\u53d1\u9001\u6253\u5305\u8bf7\u6c42   (%.2fK/s)", (double)(progress - this.lastStatisticUploadSpeedSize) / (1024.0 * ((double)(System.currentTimeMillis() - this.lastStatisticUploadSpeedTime) / 1000.0))));
                            this.lastStatisticUploadSpeedSize = progress;
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                    }
                }
            };
            stopJob.setSystem(true);
            stopJob.schedule();
            long start = System.currentTimeMillis();
            responseObj = httpClientUtils.excute((HttpContext)httpContext, httpPost, false);
            System.out.println("\u6253\u5305\u4e0a\u4f20\u8017\u65f6: " + (System.currentTimeMillis() - start));
            stopJob.cancel();
            monitor.done();
            if (!responseObj.isConnectionError()) break block27;
            if (!monitor.isCanceled()) {
                if (responseObj.getHttpErrorCode() < 500) throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", Messages.MakePackage_Net_Error));
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u4e91\u7aef\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
            stopJob.cancel();
            if (stopJob == null) return null;
            try {
                stopJob.cancel();
                return null;
            }
            catch (Throwable throwable) {}
            return null;
        }
        if (!"1001".equals(responseObj.getRspcode())) {
            String error = responseObj.getRspdesc();
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", Integer.parseInt(responseObj.getRspcode()), error, null));
        }
        JSONObject body = (JSONObject)responseObj.getBody();
        ArrayList<String> tickets = new ArrayList<String>();
        PackPlatform[] packPlatformArray = ps = PackPlatform.values();
        int n = ps.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u6253\u5305\u8bf7\u6c42\u8fd4\u56de\u7684 tickets : {0}", StringUtil.join((String)",", tickets)));
                if (!tickets.isEmpty()) {
                    DownloadDataManager.getInstance().put(tickets, this.project.getProject().getName(), this.debugMode);
                }
                monitor.subTask("APP\u5236\u4f5c\u8bf7\u6c42\u53d1\u9001\u6210\u529f");
                jSONObject = body;
                if (stopJob == null) return jSONObject;
                break;
            }
            PackPlatform p = packPlatformArray[n2];
            if (body.has(p.toString())) {
                tickets.add(body.getJSONObject(p.toString()).getString("ticket"));
            }
            ++n2;
        }
        try {
            stopJob.cancel();
            return jSONObject;
        }
        catch (Throwable throwable) {}
        return jSONObject;
        catch (Exception e) {
            try {
                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                if (!(e instanceof CoreException)) throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", e.getMessage(), (Throwable)e));
                throw (CoreException)e;
            }
            catch (Throwable throwable) {
                if (stopJob == null) throw throwable;
                try {
                    stopJob.cancel();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
    }

    public File zipPackage(boolean needConfusion) throws IOException, CoreException {
        File zip;
        File projectDir = new File(this.project.getProject().getLocationURI());
        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u5f00\u59cbZIP\u9879\u76ee: {0}", projectDir));
        File oldTmp = PackActivator.getDefault().getBundle().getDataFile(".tmp");
        if (oldTmp.exists()) {
            FileUtils.deleteQuietly((File)oldTmp);
        }
        File tmp = PackActivator.getDefault().getBundle().getDataFile(".tmp" + System.currentTimeMillis());
        try {
            String filname;
            if (tmp.exists()) {
                FileUtils.deleteQuietly((File)tmp);
            }
            tmp.mkdirs();
            JsonObject appConfigJson = ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)this.appConfig, (File)new File(projectDir, "manifest.json"), (IProject)this.project.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)false, (boolean)true, (boolean)this.debugMode);
            File appidDir = new File(tmp, this.appid);
            appidDir = MakePackage.copyPackAgeResources(this.project, needConfusion, projectDir, appidDir, appConfigJson);
            File manifastDir = new File(appidDir, MANIFAST_DIR_NAME);
            manifastDir.mkdirs();
            if (this.phoneModules.contains((Object)PackPlatform.IOS_APPSTORE) || this.phoneModules.contains((Object)PackPlatform.IOS_ADHOC) || this.phoneModules.contains((Object)PackPlatform.IOS_PB)) {
                IPadSplashScreen iPadSplashScreen;
                IPhoneSplashScreen iPhoneSplashScreen;
                IPadIcon iPadIcon;
                IPhoneIcon iPhoneIcon;
                AppleProfile appleProfile = this.appConfig.getPlus().getDistribute().getApple();
                if (appleProfile != null) {
                    JsonObject appleProfileJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("apple");
                    filname = this.copyFile(appleProfile.getMobileprovision(), "apple-mobileprovision", manifastDir);
                    if (filname != null) {
                        appleProfileJson.addProperty("mobileprovision", filname);
                    }
                    if ((filname = this.copyFile(appleProfile.getP12(), "apple-private", manifastDir)) != null) {
                        appleProfileJson.addProperty("p12", filname);
                    }
                }
                String auto = this.appConfig.getPlus().getDistribute().getIcons().getIos().getAuto();
                IOSIcon iosicon = this.appConfig.getPlus().getDistribute().getIcons().getIos();
                if (iosicon != null && auto != null && !"".equals(auto)) {
                    JsonObject iOSIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios");
                    String filname2 = this.copyFile(auto, "appstore", manifastDir);
                    if (filname2 != null) {
                        iOSIconJson.addProperty("appstore", filname2);
                    }
                }
                if ((iPhoneIcon = this.appConfig.getPlus().getDistribute().getIcons().getIos().getIphone()) != null) {
                    JsonObject iPhoneIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios").getAsJsonObject("iphone");
                    this.copyImageFiles(manifastDir, iPhoneIcon, iPhoneIconJson, "icon-iphone-");
                }
                if ((iPadIcon = this.appConfig.getPlus().getDistribute().getIcons().getIos().getIpad()) != null) {
                    JsonObject ipadIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios").getAsJsonObject("ipad");
                    this.copyImageFiles(manifastDir, iPadIcon, ipadIconJson, "icon-ipad-");
                }
                if ((iPhoneSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getIos().getIphone()) != null) {
                    JsonObject iPhoneSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("ios").getAsJsonObject("iphone");
                    this.copyImageFiles(manifastDir, iPhoneSplashScreen, iPhoneSplashScreenJson, "splash-iphone-");
                }
                if ((iPadSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getIos().getIpad()) != null) {
                    JsonObject ipadSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("ios").getAsJsonObject("ipad");
                    this.copyImageFiles(manifastDir, iPadSplashScreen, ipadSplashScreenJson, "splash-ipad-");
                }
            }
            if (this.phoneModules.contains((Object)PackPlatform.ANDROID_GOOGLEPLAY) || this.phoneModules.contains((Object)PackPlatform.ANDROID_PB)) {
                AndroidSplashScreen androidSplashScreen;
                AndroidIcon androidIcon;
                GoogleProfile googleProfile = this.appConfig.getPlus().getDistribute().getGoogle();
                if (googleProfile != null) {
                    JsonObject googleProfileJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("google");
                    filname = this.copyFile(googleProfile.getKeystore(), "google-keystore", manifastDir);
                    if (filname != null) {
                        googleProfileJson.addProperty("keystore", filname);
                    }
                }
                if ((androidIcon = this.appConfig.getPlus().getDistribute().getIcons().getAndroid()) != null) {
                    JsonObject androidIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("android");
                    this.copyImageFiles(manifastDir, androidIcon, androidIconJson, "icon-android-");
                }
                if ((androidSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getAndroid()) != null) {
                    JsonObject androidSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("android");
                    this.copyImageFiles(manifastDir, androidSplashScreen, androidSplashScreenJson, "splash-android-");
                }
            }
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String configJson = gson.toJson((JsonElement)appConfigJson);
            FileUtils.write((File)new File(appidDir, "manifest.json"), (CharSequence)configJson, (String)"utf-8");
            zip = PackActivator.getDefault().getBundle().getDataFile(String.valueOf(this.appid) + ".wgt");
            ZipUtils.zip((String)tmp.getAbsolutePath(), (String)zip.getAbsolutePath());
            IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("ZIP\u9879\u76ee{0} \u7ed3\u675f: {1}", projectDir, zip));
        }
        finally {
            if (tmp.exists()) {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        return zip;
    }

    private void copyImageFiles(File manifastDir, Object imageObject, JsonObject imageJson, String prefix) throws IOException {
        Field[] fields = imageObject.getClass().getDeclaredFields();
        String filname = null;
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                String fieldName = field.getName();
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    fieldName = serializedName.value();
                }
                if (StringUtil.isNotEmpty((String)(value = (String)field.get(imageObject))) && (filname = this.copyFile(value, String.valueOf(prefix) + fieldName, manifastDir)) != null) {
                    imageJson.addProperty(fieldName, filname);
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
    }

    public static File copyPackAgeResources(HMobileProject project, boolean needConfusion, File sourceFile, File targetDir, JsonObject appConfigJson) throws IOException, CoreException {
        return MakePackage.copyPackAgeResources(project, needConfusion, true, sourceFile, targetDir, appConfigJson);
    }

    public static File copyPackAgeResources(HMobileProject project, boolean needConfusion, final boolean checkError, final File sourceFile, File targetDir, JsonObject appConfigJson) throws IOException, CoreException {
        final HashSet<File> unpackageFiles = new HashSet<File>();
        unpackageFiles.add(new File(sourceFile, "unpackage"));
        unpackageFiles.add(new File(sourceFile, "node_modules"));
        if (appConfigJson.has("unpackage")) {
            try {
                JsonArray array = appConfigJson.getAsJsonArray("unpackage");
                if (array != null && array.size() > 0) {
                    for (JsonElement jsonElement : array) {
                        if (!jsonElement.isJsonPrimitive()) continue;
                        unpackageFiles.add(new File(sourceFile, jsonElement.getAsString()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        final String pPath = String.valueOf(sourceFile.getAbsolutePath()) + File.separator;
        FileUtils.copyDirectory((File)sourceFile, (File)targetDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fName = pathname.getName();
                if (checkError && chinesePattern.matcher(fName).find()) {
                    throw new IllegalArgumentException("App\u6253\u5305\u65f6\uff0c\u9879\u76ee\u4e2d\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\u6216\u5168\u89d2\u5b57\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002\r\n   \u6587\u4ef6\u8def\u5f84\uff1a" + pathname.getAbsolutePath().replace(sourceFile.getAbsolutePath(), ""));
                }
                String fPath = pathname.getAbsolutePath();
                if ("appstream.json".equals(fPath = fPath.replace(pPath, "")) || fPath.startsWith("appstream@") && fPath.endsWith(".bak.json")) {
                    return false;
                }
                if (unpackageFiles.contains(pathname)) {
                    return false;
                }
                if ("manifest.json.encrypted".equalsIgnoreCase(fName)) {
                    return false;
                }
                return !fName.startsWith(".");
            }
        });
        ProjectProcessors.processorProject((HMobileProject)project, (File)targetDir, (File)targetDir, (boolean)true, (IProjectProcessor.Profile)IProjectProcessor.Profile.PRODUCTION);
        if (needConfusion) {
            PrimaryConfusionUtils.addConfusionInfo2Target(project, targetDir, appConfigJson);
        } else if (appConfigJson.has("plus")) {
            appConfigJson.getAsJsonObject("plus").remove("confusion");
        }
        appConfigJson.remove("dependencies");
        appConfigJson.remove("unpackage");
        appConfigJson.remove("@wap2app_dev");
        return targetDir;
    }

    public String copyFile(String fileStr, String fileName, File dir) throws IOException {
        return MakePackage.copyFile(this.project.getProject(), fileStr, fileName, dir);
    }

    public static String copyFile(IProject project, String fileStr, String fileName, File dir) throws IOException {
        File file;
        if (StringUtil.isNotBlank((String)fileStr) && (file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)project, (String)fileStr)).exists()) {
            int index = file.getName().lastIndexOf(".");
            fileName = String.valueOf(fileName) + (index >= 0 ? file.getName().substring(index) : "");
            FileUtils.copyFile((File)file, (File)new File(dir, fileName));
            return fileName;
        }
        return null;
    }
}

