/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.formatter;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.RubySourceConfiguration;
import com.aptana.editor.ruby.RubySourceViewerConfiguration;
import com.aptana.editor.ruby.formatter.RubyFormatter;
import com.aptana.editor.ruby.formatter.RubyFormatterPlugin;
import com.aptana.editor.ruby.formatter.preferences.RubyFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubyFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.ruby.formatter.epl", "ruby.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatterPreview.rb";
    private static final String[] KEYS = new String[]{"ruby.formatter.formatter.tabulation.char", "ruby.formatter.formatter.indentation.size", "ruby.formatter.formatter.tabulation.size", "ruby.formatter.indent.class", "ruby.formatter.indent.module", "ruby.formatter.indent.method", "ruby.formatter.indent.blocks", "ruby.formatter.indent.if", "ruby.formatter.indent.case", "ruby.formatter.indent.when", "ruby.formatter.line.file.require.after", "ruby.formatter.line.file.module.between", "ruby.formatter.line.file.class.between", "ruby.formatter.line.file.method.between", "ruby.formatter.line.first.before", "ruby.formatter.line.module.before", "ruby.formatter.line.class.before", "ruby.formatter.line.method.before", "ruby.formatter.lines.preserve", "ruby.formatter.wrap.comments", "ruby.formatter.wrap.comments.length", "ruby.formatter.formatter.on.off.enabled", "ruby.formatter.formatter.on", "ruby.formatter.formatter.off"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            result[i] = new PreferenceKey("com.aptana.editor.ruby.formatter.epl", key);
            ++i;
        }
        return result;
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public IScriptFormatter createFormatter(String lineDelimiter, Map<String, String> preferences) {
        return new RubyFormatter(lineDelimiter, preferences, this.getMainContentType());
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new RubyFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new RubySourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public IPreferenceStore getPreferenceStore() {
        return RubyFormatterPlugin.getDefault().getPreferenceStore();
    }

    public Object getPartitioningConfiguration() {
        return RubySourceConfiguration.getDefault();
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return EclipseUtil.instanceScope().getNode("com.aptana.editor.ruby");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("ruby.formatter.formatter.tabulation.char");
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)RubyEditorPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)RubyEditorPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected String getFormatterTabSizeKey() {
        return "ruby.formatter.formatter.tabulation.size";
    }
}

