/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.utils.Activator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

public class StatusLineUtils {
    private static final Image INFO_IMG = Activator.getImage("/icons/full/toc_obj.gif");
    private static final Image ERROR_IMG = Activator.getImage("/icons/full/quickfix_error.png");
    static ClearMessageJob correntClearMessageJob = null;
    static HashMap<IStatusLineManager, ClearMessageJob> clearMessageJobs = new HashMap();

    public static Link showStatusMessage(final String message, final long timeout, final boolean error, final boolean getLink) {
        final Link[] link = new Link[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Display.getDefault().getActiveShell() == null || Display.getDefault().getActiveShell().isDisposed()) {
                    return;
                }
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    workbenchWindow.setStatusLineVisible(true);
                    WWinActionBars bars = workbenchWindow.getActionBars();
                    IStatusLineManager lineManager = bars.getStatusLineManager();
                    if (error) {
                        lineManager.setErrorMessage(ERROR_IMG, message);
                    } else {
                        lineManager.setMessage(INFO_IMG, message);
                    }
                    lineManager.update(true);
                    if (clearMessageJobs.get(lineManager) != null) {
                        clearMessageJobs.get(lineManager).schedule(timeout);
                    } else {
                        ClearMessageJob clearMessageJob = new ClearMessageJob(lineManager);
                        clearMessageJobs.put(lineManager, clearMessageJob);
                        clearMessageJob.schedule(timeout);
                    }
                    if (getLink && lineManager instanceof StatusLineManager && ((StatusLineManager)lineManager).getControl() instanceof Composite) {
                        Control[] childs;
                        Control[] controlArray = childs = ((Composite)((StatusLineManager)lineManager).getControl()).getChildren();
                        int n = childs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            if (child instanceof Composite) {
                                Control[] childs2;
                                Control[] controlArray2 = childs2 = ((Composite)child).getChildren();
                                int n3 = childs2.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Control child2 = controlArray2[n4];
                                    if (child2 instanceof Link) {
                                        link[0] = (Link)child2;
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                }
            }
        });
        return link[0];
    }

    public static void showStatusMessage(String message, long timeout) {
        StatusLineUtils.showStatusMessage(message, timeout, false, false);
    }

    public static void showErrorMessage(String message, long timeout) {
        StatusLineUtils.showStatusMessage(message, timeout, true, false);
    }

    static class ClearMessageJob
    extends UIJob {
        private IStatusLineManager lineManager = null;

        public ClearMessageJob(IStatusLineManager lineManager) {
            super("\u81ea\u52a8\u6e05\u9664\u72b6\u6001\u680f\u4fe1\u606f");
            this.lineManager = lineManager;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.lineManager != null) {
                this.lineManager.setMessage(null, null);
                this.lineManager.setErrorMessage(null, null);
                this.lineManager.update(true);
            }
            return Status.OK_STATUS;
        }
    }
}

