/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class ResourceUtil {
    public static final String PROJECT_UNPACKAGE_DIR = "unpackage";
    public static final String PACKAGE_DOWNLOAD = "release";
    public static final String DEBUG_PACKAGE_DOWNLOAD = "debug";
    public static final String DEBUG_PACKAGE_NAME_ANDROID = "android_debug.apk";
    public static final String DEBUG_PACKAGE_NAME_IOS = "iOS_debug.ipa";
    public static final String PROJECT_RESOURCE_DIR = "res";
    public static final String PROJECT_BACKUP_DIR = "backup";
    private static final String SCHEME_FILE = "file";
    private static final String UNC_PREFIX = "//";

    public static String resourcePathToString(URL url) {
        File file = ResourceUtil.resourcePathToFile(url);
        return file == null ? null : file.getAbsolutePath();
    }

    public static File resourcePathToFile(URL url) {
        URI fileURI = ResourceUtil.resourcePathToURI(url);
        return fileURI == null ? null : new File(fileURI);
    }

    public static URI resourcePathToURI(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            return ResourceUtil.toURI(fileURL);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Unable to convert URL to file URL: {0}", url);
            HBLog.logError((Plugin)Activator.getDefault(), message, e);
        }
        catch (URISyntaxException e) {
            String message = MessageFormat.format("Unable to convert file URL to URI: {0}", url);
            HBLog.logError((Plugin)Activator.getDefault(), message, e);
        }
        return null;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        if (SCHEME_FILE.equals(url.getProtocol())) {
            String pathString = url.toExternalForm().substring(5);
            if (pathString.indexOf(47) != 0) {
                pathString = String.valueOf('/') + pathString;
            } else if (pathString.startsWith(UNC_PREFIX) && !pathString.startsWith(UNC_PREFIX, 2)) {
                pathString = ResourceUtil.ensureUNCPath(pathString);
            }
            return new URI(SCHEME_FILE, null, pathString, null);
        }
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuilder result = new StringBuilder(len);
        int i = 0;
        while (i < 4) {
            if (i >= len || path.charAt(i) != '/') {
                result.append('/');
            }
            ++i;
        }
        result.append(path);
        return result.toString();
    }

    public static IFile getIFileFromURL(URI uri) {
        String urlText = uri.getPath();
        int nameIndex = urlText.indexOf("/", 1);
        if (nameIndex < 1) {
            return null;
        }
        String projectName = urlText.substring(1, nameIndex);
        String path = urlText.substring(nameIndex + 1, urlText.length());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
    }

    public static String getLineSeparatorValue(IProject project) {
        Object scope = project != null ? new ProjectScope(project) : EclipseUtil.instanceScope();
        IScopeContext[] scopeContext = new IScopeContext[]{scope};
        IEclipsePreferences node = scopeContext[0].getNode("org.eclipse.core.runtime");
        return node.get("line.separator", System.getProperty("line.separator"));
    }

    public static IFolder getAppProjectResDir(IProject project, String ... dirNames) throws CoreException {
        if (project == null || !project.exists()) {
            return null;
        }
        IFolder ifolder = ResourceUtil.getAppProjectUnPackageDir(project, PROJECT_RESOURCE_DIR, dirNames);
        return ifolder;
    }

    public static IFolder getAppProjectUnPackageDir(IProject project, String dirName, String ... subDirNames) throws CoreException {
        if (project == null || !project.exists()) {
            return null;
        }
        IFolder ifolder = ResourceUtil.createFolder(project.getFolder(PROJECT_UNPACKAGE_DIR), true, true, null);
        if (dirName != null) {
            ifolder = ResourceUtil.createFolder(ifolder.getFolder(dirName), true, true, null);
        }
        if (subDirNames != null) {
            String[] stringArray = subDirNames;
            int n = subDirNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subDirName = stringArray[n2];
                ifolder = ResourceUtil.createFolder(ifolder.getFolder(subDirName), true, true, null);
                ++n2;
            }
        }
        return ifolder;
    }

    public static IFolder createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ResourceUtil.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
        return folder;
    }

    public static File getAbsoluteFileFormProjectOrSystemt(IProject projcet, String pathStr) {
        File locaFile;
        IFile file;
        if (StringUtil.isBlank(pathStr)) {
            return null;
        }
        Path path = new Path(pathStr);
        if (projcet != null && projcet.exists() && (file = projcet.getFile((IPath)path)) != null && (locaFile = file.getLocation().toFile()).exists()) {
            return locaFile;
        }
        File result = new File(path.toString());
        return result;
    }

    public static void addToLocalHistory(IFile file) {
        try {
            IWorkspace wspace = file.getWorkspace();
            Workspace workspace = null;
            if (!(wspace instanceof Workspace)) {
                return;
            }
            workspace = (Workspace)wspace;
            WorkManager workManager = workspace.getWorkManager();
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, "", null);
            ResourceTree tree = new ResourceTree(workspace.getFileSystemManager(), workManager.getLock(), status, 3);
            tree.addToLocalHistory(file);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

