/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.InputStreamGobbler;
import com.pandora.core.utils.OutputStreamThread;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ProcessStatus;
import com.pandora.core.utils.ResourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ProcessUtil {
    public static final String TEXT_TO_OBFUSCATE = "textToObfuscate";
    private static ProcessUtil fgInstance;
    public static String REDIRECT_ERROR_STREAM;

    static {
        REDIRECT_ERROR_STREAM = "redirectErrorStream";
    }

    protected ProcessUtil() {
    }

    public static synchronized ProcessUtil instance() {
        if (fgInstance == null) {
            fgInstance = new ProcessUtil();
        }
        return fgInstance;
    }

    public static String outputForCommand(String command, IPath workingDir, String ... args) {
        return ProcessUtil.outputForCommand(command, workingDir, null, args);
    }

    public static String outputForCommand(String command, IPath workingDir, Map<String, String> env, String ... args) {
        IStatus result = ProcessUtil.runInBackground(command, workingDir, env, args);
        if (result == null) {
            return null;
        }
        return result.getMessage();
    }

    public static IStatus runInBackground(String command, IPath workingDir, String ... args) {
        return ProcessUtil.runInBackground(command, workingDir, null, args);
    }

    public static IStatus runInBackground(String command, IPath workingDir, Map<String, String> env, String ... args) {
        return ProcessUtil.runInBackground(command, workingDir, null, env, args);
    }

    public static String outputForProcess(Process process) {
        IStatus result = ProcessUtil.processData(process, null);
        if (result == null) {
            return null;
        }
        return result.getMessage();
    }

    public static IStatus processResult(Process process) {
        return ProcessUtil.processData(process, null);
    }

    private static IStatus processData(Process process, String input) {
        String lineSeparator = ResourceUtil.getLineSeparatorValue(null);
        try {
            String encode;
            OutputStreamThread writerThread = null;
            String string = encode = PlatformUtil.isWindows() ? "gbk" : "UTF-8";
            if (input != null) {
                writerThread = new OutputStreamThread(process.getOutputStream(), input, encode);
            }
            InputStreamGobbler readerGobbler = new InputStreamGobbler(process.getInputStream(), lineSeparator, encode);
            InputStreamGobbler errorGobbler = new InputStreamGobbler(process.getErrorStream(), lineSeparator, encode);
            if (writerThread != null) {
                writerThread.start();
            }
            readerGobbler.start();
            errorGobbler.start();
            int exitValue = process.waitFor();
            if (writerThread != null) {
                writerThread.interrupt();
                writerThread.join();
            }
            readerGobbler.interrupt();
            errorGobbler.interrupt();
            readerGobbler.join();
            errorGobbler.join();
            String stdout = readerGobbler.getResult();
            String stderr = errorGobbler.getResult();
            return new ProcessStatus(exitValue, stdout, stderr);
        }
        catch (InterruptedException e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
            return null;
        }
    }

    public static IStatus runInBackground(String command, IPath workingDirectory, String input, Map<String, String> environment, String ... arguments) {
        try {
            Process p = ProcessUtil.run(command, workingDirectory, environment, arguments);
            return ProcessUtil.processData(p, input);
        }
        catch (IOException e) {
            return new Status(4, "com.pandora.core.utils", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public static Process run(String command, IPath workingDirectory, Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(arguments));
        commands.add(0, command);
        return ProcessUtil.run(commands, workingDirectory, environment);
    }

    public static Process run(String command, IPath workingDirectory, String ... arguments) throws IOException, CoreException {
        return ProcessUtil.run(command, workingDirectory, null, arguments);
    }

    public static Process run(List<String> command, IPath workingDirectory, Map<String, String> environment) throws IOException, CoreException {
        return ProcessUtil.instance().doRun(command, workingDirectory, environment);
    }

    public Process doRun(List<String> command, IPath workingDirectory, Map<String, String> environment) throws IOException, CoreException {
        ProcessBuilder processBuilder = this.createProcessBuilder(command);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        TreeMap<String, String> map = null;
        if (environment != null && !environment.isEmpty()) {
            map = new TreeMap<String, String>(environment);
            map.remove(TEXT_TO_OBFUSCATE);
            processBuilder.environment().putAll(environment);
        }
        if (environment != null && environment.containsKey(REDIRECT_ERROR_STREAM)) {
            processBuilder.redirectErrorStream(true);
        }
        return this.startProcess(processBuilder);
    }

    protected Process startProcess(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    protected void logInfo(String msg) {
        HBLog.logInfo((Plugin)Activator.getDefault(), msg);
    }

    protected ProcessBuilder createProcessBuilder(List<String> command) {
        return new ProcessBuilder(command);
    }

    public static int waitForProcess(Process process, final long timeout, boolean forceKillAfterTimeout) {
        final Thread waitingThread = Thread.currentThread();
        Thread timeoutThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    waitingThread.interrupt();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        int exitcode = -1;
        if (timeout > 0L) {
            block9: {
                try {
                    try {
                        timeoutThread.start();
                        exitcode = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                        timeoutThread.interrupt();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    timeoutThread.interrupt();
                    throw throwable;
                }
                timeoutThread.interrupt();
            }
            if (forceKillAfterTimeout) {
                process.destroy();
            }
        }
        try {
            exitcode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return exitcode;
    }
}

