/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.utils.StringUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProcessStatus
extends Status {
    private String stdout;
    private String stderr;

    public ProcessStatus(int exitCode, String stdout, String stderr) {
        super(exitCode == 0 ? 0 : 4, "com.pandora.core.utils", exitCode, ProcessStatus.generateMessage(exitCode, stdout, stderr), null);
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private static String generateMessage(int exitCode, String stdOut, String stderr) {
        if (exitCode != 0 && StringUtil.isEmpty(stdOut)) {
            return stderr;
        }
        if (stdOut != null && stdOut.endsWith("\n")) {
            return stdOut.substring(0, stdOut.length() - 1);
        }
        return stdOut;
    }

    public String getStdErr() {
        return this.stderr;
    }

    public String getStdOut() {
        return this.stdout;
    }

    public IStatus getStdErrStatus() {
        return new Status(this.getSeverity(), this.getPlugin(), this.getCode(), this.getStdErr(), null);
    }
}

