/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class MarkdownUtils {
    public static boolean isMarkDown(String fileName) {
        String name;
        return fileName != null && ((name = fileName.toLowerCase()).endsWith(".md") || name.endsWith(".markdown") || name.endsWith(".mdown"));
    }

    public static boolean isMarkDownHtmlValid(File mdFile, File htmlFolder) {
        block4: {
            if (mdFile != null && mdFile.exists()) break block4;
            return false;
        }
        try {
            File targetHtmlFile = MarkdownUtils.getTargetHtmlFile(htmlFolder);
            if (targetHtmlFile != null) {
                String newName = String.valueOf(mdFile.getName()) + ".html";
                return targetHtmlFile.lastModified() == mdFile.lastModified() && targetHtmlFile.getName().equals(newName);
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
        }
        return false;
    }

    public static File markdownToHtmlFolder(File mdFile, File htmlFolder) {
        block6: {
            if (mdFile != null && mdFile.exists()) break block6;
            return null;
        }
        try {
            File templateHtmlFile = MarkdownUtils.getTemplateHtmlFile(htmlFolder);
            File targetHtmlFile = MarkdownUtils.getTargetHtmlFile(htmlFolder);
            if (targetHtmlFile != null) {
                String newName = String.valueOf(mdFile.getName()) + ".html";
                if (targetHtmlFile.lastModified() != mdFile.lastModified() || !targetHtmlFile.getName().equals(newName)) {
                    if (!targetHtmlFile.getName().equals(newName)) {
                        File newFile = new File(targetHtmlFile.getParent(), newName);
                        targetHtmlFile.renameTo(newFile);
                        targetHtmlFile = newFile;
                    }
                    FileUtils.writeStringToFile((File)targetHtmlFile, (String)FileUtils.readFileToString((File)templateHtmlFile, (String)"utf-8").replace("{%CONTENT%}", FileUtils.readFileToString((File)mdFile, (String)"utf-8")), (String)"utf-8");
                    targetHtmlFile.setLastModified(mdFile.lastModified());
                }
                return targetHtmlFile;
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
        }
        return null;
    }

    public static File markdownToHtmlFolder(String markdownText, File htmlFolder) {
        block4: {
            if (markdownText != null) break block4;
            return null;
        }
        try {
            File templateHtmlFile = MarkdownUtils.getTemplateHtmlFile(htmlFolder);
            File targetHtmlFile = MarkdownUtils.getTargetHtmlFile(htmlFolder);
            if (targetHtmlFile != null) {
                FileUtils.writeStringToFile((File)targetHtmlFile, (String)FileUtils.readFileToString((File)templateHtmlFile, (String)"utf-8").replace("{%CONTENT%}", markdownText), (String)"utf-8");
                return targetHtmlFile;
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
        }
        return null;
    }

    private static File getTemplateHtmlFile(File htmlFolder) throws IOException {
        Bundle uiBundle = Platform.getBundle((String)"com.pandora.ui");
        URL url = FileLocator.toFileURL((URL)uiBundle.getResource("content/markdown"));
        File templateFolder = new File(url.getFile());
        File templateHtmlFile = new File(templateFolder, "showdown.html");
        if (!htmlFolder.exists()) {
            htmlFolder.mkdirs();
            FileUtils.copyDirectory((File)templateFolder, (File)htmlFolder);
        }
        return templateHtmlFile;
    }

    private static File getTargetHtmlFile(File htmlFolder) {
        if (htmlFolder == null || !htmlFolder.exists()) {
            return null;
        }
        File targetHtmlFile = htmlFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".html");
            }
        })[0];
        return targetHtmlFile;
    }
}

