/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFile;

public class FileUtil {
    public static boolean deleteRecursively(File dir) {
        if (dir == null) {
            return false;
        }
        boolean result = true;
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result = result && FileUtil.deleteRecursively(child);
                ++n2;
            }
        }
        return result && dir.delete();
    }

    public static void copyDirectiory(String sourceDir, String targetDir) {
        File[] files;
        new File(targetDir).mkdirs();
        File[] fileArray = files = new File(sourceDir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                String fname = file.getName();
                if (file.isFile()) {
                    File sourceFile = file;
                    File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + fname);
                    FileUtil.copyFile(sourceFile, targetFile);
                }
                if (file.isDirectory()) {
                    String dir1 = String.valueOf(sourceDir) + "/" + fname;
                    String dir2 = String.valueOf(targetDir) + "/" + fname;
                    FileUtil.copyDirectiory(dir1, dir2);
                }
            }
            ++n2;
        }
    }

    public static void copyFile(File sourceFile, File targetFile) {
        FileUtil.copy(sourceFile, targetFile);
    }

    public static boolean copy(File sourceFile, File targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static File convertIFileToFile(IFile ifile) throws FileNotFoundException {
        File file = null;
        if (!ifile.exists()) {
            throw new FileNotFoundException(ifile.getFullPath().toOSString());
        }
        file = ifile.getLocation().toFile();
        return file;
    }
}

