/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.sun.jna.Library;
import com.sun.jna.Native;

public class Environment {
    static POSIX libc = new POSIX();

    public static int setEnv(String key, String value) {
        return libc.setenv(key, value, 1);
    }

    public static interface LinuxLibC
    extends Library {
        public int setenv(String var1, String var2, int var3);

        public int unsetenv(String var1);
    }

    public static class POSIX {
        static Object libc = System.getProperty("os.name").equals("Linux") ? Native.loadLibrary((String)"c", LinuxLibC.class) : Native.loadLibrary((String)"msvcrt", WinLibC.class);

        public int setenv(String name, String value, int overwrite) {
            if (libc instanceof LinuxLibC) {
                return ((LinuxLibC)libc).setenv(name, value, overwrite);
            }
            return ((WinLibC)libc)._putenv(String.valueOf(name) + "=" + value);
        }

        public int unsetenv(String name) {
            if (libc instanceof LinuxLibC) {
                return ((LinuxLibC)libc).unsetenv(name);
            }
            return ((WinLibC)libc)._putenv(String.valueOf(name) + "=");
        }
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

