/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.console.IMessageConsole;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtils {
    private static IMessageConsole instance;

    public static MessageConsoleStream createConsoleStream(String consoleName, ImageDescriptor descriptor, boolean closeOthers) {
        MessageConsole console = new MessageConsole(consoleName, descriptor, false);
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        if (consoles != null && consoles.length > 0) {
            IConsole c = consoles[0];
            if (c instanceof MessageConsole) {
                MessageConsole msgConsole = (MessageConsole)c;
                console.setBackground(msgConsole.getBackground());
                console.setFont(msgConsole.getFont());
                console.setConsoleWidth(msgConsole.getConsoleWidth());
                console.setWaterMarks(msgConsole.getLowWaterMark(), msgConsole.getHighWaterMark());
            }
            if (closeOthers) {
                consoleManager.removeConsoles(consoles);
            }
        }
        consoleManager.addConsoles(new IConsole[]{console});
        consoleManager.showConsoleView((IConsole)console);
        return console.newMessageStream();
    }

    public static MessageConsoleStream getFristConsoleStream() {
        IConsole c;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        if (consoles != null && consoles.length > 0 && (c = consoles[0]) instanceof MessageConsole) {
            consoleManager.showConsoleView(c);
            return ((MessageConsole)c).newMessageStream();
        }
        return null;
    }

    public static IMessageConsole getMessageConsole(boolean show) {
        if (instance == null) {
            try {
                IExtension[] extensions;
                IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint("com.pandora.core.console");
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    if (iConfigurationElementArray.length != 0) {
                        IConfigurationElement element = iConfigurationElementArray[0];
                        instance = (IMessageConsole)element.createExecutableExtension("class");
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)Activator.getDefault(), e);
            }
        }
        if (show && instance != null) {
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)instance.getConsole());
        }
        return instance;
    }
}

