/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.x500.style;

import com.pandora.core.sign.bouncycastle.asn1.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.ASN1String;
import com.pandora.core.sign.bouncycastle.asn1.DERUniversalString;
import com.pandora.core.sign.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.pandora.core.sign.bouncycastle.asn1.x500.RDN;
import com.pandora.core.sign.bouncycastle.asn1.x500.X500NameBuilder;
import com.pandora.core.sign.bouncycastle.asn1.x500.X500NameStyle;
import com.pandora.core.sign.bouncycastle.asn1.x500.style.X500NameTokenizer;
import com.pandora.core.sign.bouncycastle.util.Strings;
import com.pandora.core.sign.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    public static RDN[] rDNsFromString(String name, X500NameStyle x500Style) {
        X500NameTokenizer nTok = new X500NameTokenizer(name);
        X500NameBuilder builder = new X500NameBuilder(x500Style);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String attr = token.substring(0, index);
            String value = token.substring(index + 1);
            ASN1ObjectIdentifier oid = x500Style.attrNameToOID(attr);
            if (value.indexOf(43) > 0) {
                X500NameTokenizer vTok = new X500NameTokenizer(value, '+');
                String v = vTok.nextToken();
                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                Vector<String> values = new Vector<String>();
                oids.addElement(oid);
                values.addElement(v);
                while (vTok.hasMoreTokens()) {
                    String sv = vTok.nextToken();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    oids.addElement(x500Style.attrNameToOID(nm));
                    values.addElement(vl);
                }
                builder.addMultiValuedRDN(IETFUtils.toOIDArray(oids), IETFUtils.toValueArray(values));
                continue;
            }
            builder.addRDN(oid, value);
        }
        return builder.build().getRDNs();
    }

    private static String[] toValueArray(Vector values) {
        String[] tmp = new String[values.size()];
        int i = 0;
        while (i != tmp.length) {
            tmp[i] = (String)values.elementAt(i);
            ++i;
        }
        return tmp;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector oids) {
        ASN1ObjectIdentifier[] tmp = new ASN1ObjectIdentifier[oids.size()];
        int i = 0;
        while (i != tmp.length) {
            tmp[i] = (ASN1ObjectIdentifier)oids.elementAt(i);
            ++i;
        }
        return tmp;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String name, Hashtable lookUp) {
        if (Strings.toUpperCase(name).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(name);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)lookUp.get(Strings.toLowerCase(name));
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public static ASN1Encodable valueFromHexString(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        int index = 0;
        while (index != data.length) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
            } else {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
            }
            ++index;
        }
        return ASN1Primitive.fromByteArray(data);
    }

    public static void appendRDN(StringBuffer buf, RDN rdn, Hashtable oidSymbols) {
        if (rdn.isMultiValued()) {
            AttributeTypeAndValue[] atv = rdn.getTypesAndValues();
            boolean firstAtv = true;
            int j = 0;
            while (j != atv.length) {
                if (firstAtv) {
                    firstAtv = false;
                } else {
                    buf.append('+');
                }
                IETFUtils.appendTypeAndValue(buf, atv[j], oidSymbols);
                ++j;
            }
        } else {
            IETFUtils.appendTypeAndValue(buf, rdn.getFirst(), oidSymbols);
        }
    }

    public static void appendTypeAndValue(StringBuffer buf, AttributeTypeAndValue typeAndValue, Hashtable oidSymbols) {
        String sym = (String)oidSymbols.get(typeAndValue.getType());
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(typeAndValue.getType().getId());
        }
        buf.append('=');
        buf.append(IETFUtils.valueToString(typeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable value) {
        StringBuffer vBuf = new StringBuffer();
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            String v = ((ASN1String)((Object)value)).getString();
            if (v.length() > 0 && v.charAt(0) == '#') {
                vBuf.append("\\" + v);
            } else {
                vBuf.append(v);
            }
        } else {
            try {
                vBuf.append("#" + IETFUtils.bytesToString(Hex.encode(value.toASN1Primitive().getEncoded("DER"))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int end = vBuf.length();
        int index = 0;
        if (vBuf.length() >= 2 && vBuf.charAt(0) == '\\' && vBuf.charAt(1) == '#') {
            index += 2;
        }
        while (index != end) {
            if (vBuf.charAt(index) == ',' || vBuf.charAt(index) == '\"' || vBuf.charAt(index) == '\\' || vBuf.charAt(index) == '+' || vBuf.charAt(index) == '=' || vBuf.charAt(index) == '<' || vBuf.charAt(index) == '>' || vBuf.charAt(index) == ';') {
                vBuf.insert(index, "\\");
                ++index;
                ++end;
            }
            ++index;
        }
        return vBuf.toString();
    }

    private static String bytesToString(byte[] data) {
        char[] cs = new char[data.length];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(data[i] & 0xFF);
            ++i;
        }
        return new String(cs);
    }

    public static String canonicalize(String s) {
        ASN1Primitive obj;
        String value = Strings.toLowerCase(s.trim());
        if (value.length() > 0 && value.charAt(0) == '#' && (obj = IETFUtils.decodeObject(value)) instanceof ASN1String) {
            value = Strings.toLowerCase(((ASN1String)((Object)obj)).getString().trim());
        }
        value = IETFUtils.stripInternalSpaces(value);
        return value;
    }

    private static ASN1Primitive decodeObject(String oValue) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(oValue.substring(1)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unknown encoding in name: " + e);
        }
    }

    public static String stripInternalSpaces(String str) {
        StringBuffer res = new StringBuffer();
        if (str.length() != 0) {
            char c1 = str.charAt(0);
            res.append(c1);
            int k = 1;
            while (k < str.length()) {
                char c2 = str.charAt(k);
                if (c1 != ' ' || c2 != ' ') {
                    res.append(c2);
                }
                c1 = c2;
                ++k;
            }
        }
        return res.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean rDNAreEqual(RDN rdn1, RDN rdn2) {
        if (rdn1.isMultiValued()) {
            AttributeTypeAndValue[] atvs2;
            if (!rdn2.isMultiValued()) return false;
            AttributeTypeAndValue[] atvs1 = rdn1.getTypesAndValues();
            if (atvs1.length != (atvs2 = rdn2.getTypesAndValues()).length) {
                return false;
            }
            int i = 0;
            while (i != atvs1.length) {
                if (!IETFUtils.atvAreEqual(atvs1[i], atvs2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (rdn2.isMultiValued()) return false;
            return IETFUtils.atvAreEqual(rdn1.getFirst(), rdn2.getFirst());
        }
    }

    private static boolean atvAreEqual(AttributeTypeAndValue atv1, AttributeTypeAndValue atv2) {
        String v2;
        ASN1ObjectIdentifier o2;
        if (atv1 == atv2) {
            return true;
        }
        if (atv1 == null) {
            return false;
        }
        if (atv2 == null) {
            return false;
        }
        ASN1ObjectIdentifier o1 = atv1.getType();
        if (!o1.equals(o2 = atv2.getType())) {
            return false;
        }
        String v1 = IETFUtils.canonicalize(IETFUtils.valueToString(atv1.getValue()));
        return v1.equals(v2 = IETFUtils.canonicalize(IETFUtils.valueToString(atv2.getValue())));
    }
}

