/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.copy;

import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1ObjectIdentifier;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1TaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.copy.OIDTokenizer;
import com.pandora.core.sign.bouncycastle.asn1.copy.StreamUtil;
import com.pandora.core.sign.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERObjectIdentifier
extends ASN1Primitive {
    String identifier;
    private byte[] body;
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static ASN1ObjectIdentifier[][] cache = new ASN1ObjectIdentifier[256][];

    public static ASN1ObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)obj;
        }
        if (obj instanceof DERObjectIdentifier) {
            return new ASN1ObjectIdentifier(((DERObjectIdentifier)obj).getId());
        }
        if (obj instanceof ASN1Encodable && ((ASN1Encodable)obj).toASN1Primitive() instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)((ASN1Encodable)obj).toASN1Primitive();
        }
        if (obj instanceof byte[]) {
            return ASN1ObjectIdentifier.fromOctetString((byte[])obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(o);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] bytes) {
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        int i = 0;
        while (i != bytes.length) {
            int b = bytes[i] & 0xFF;
            if (value <= 0xFFFFFFFFFFFF80L) {
                value += (long)(b & 0x7F);
                if ((b & 0x80) == 0) {
                    if (first) {
                        if (value < 40L) {
                            objId.append('0');
                        } else if (value < 80L) {
                            objId.append('1');
                            value -= 40L;
                        } else {
                            objId.append('2');
                            value -= 80L;
                        }
                        first = false;
                    }
                    objId.append('.');
                    objId.append(value);
                    value = 0L;
                } else {
                    value <<= 7;
                }
            } else {
                if (bigValue == null) {
                    bigValue = BigInteger.valueOf(value);
                }
                bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
                if ((b & 0x80) == 0) {
                    if (first) {
                        objId.append('2');
                        bigValue = bigValue.subtract(BigInteger.valueOf(80L));
                        first = false;
                    }
                    objId.append('.');
                    objId.append(bigValue);
                    bigValue = null;
                    value = 0L;
                } else {
                    bigValue = bigValue.shiftLeft(7);
                }
            }
            ++i;
        }
        this.identifier = objId.toString();
        this.body = Arrays.clone(bytes);
    }

    public DERObjectIdentifier(String identifier) {
        if (!DERObjectIdentifier.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(ByteArrayOutputStream out, long fieldValue) {
        byte[] result = new byte[9];
        int pos = 8;
        result[pos] = (byte)((int)fieldValue & 0x7F);
        while (fieldValue >= 128L) {
            result[--pos] = (byte)((int)(fieldValue >>= 7) & 0x7F | 0x80);
        }
        out.write(result, pos, 9 - pos);
    }

    private void writeField(ByteArrayOutputStream out, BigInteger fieldValue) {
        int byteCount = (fieldValue.bitLength() + 6) / 7;
        if (byteCount == 0) {
            out.write(0);
        } else {
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            int i = byteCount - 1;
            while (i >= 0) {
                tmp[i] = (byte)(tmpValue.intValue() & 0x7F | 0x80);
                tmpValue = tmpValue.shiftRight(7);
                --i;
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp, 0, tmp.length);
        }
    }

    private void doOutput(ByteArrayOutputStream aOut) {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        int first = Integer.parseInt(tok.nextToken()) * 40;
        String secondToken = tok.nextToken();
        if (secondToken.length() <= 18) {
            this.writeField(aOut, (long)first + Long.parseLong(secondToken));
        } else {
            this.writeField(aOut, new BigInteger(secondToken).add(BigInteger.valueOf(first)));
        }
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() <= 18) {
                this.writeField(aOut, Long.parseLong(token));
                continue;
            }
            this.writeField(aOut, new BigInteger(token));
        }
    }

    protected synchronized byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            this.doOutput(bOut);
            this.body = bOut.toByteArray();
        }
        return this.body;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() throws IOException {
        int length = this.getBody().length;
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        byte[] enc = this.getBody();
        out.write(6);
        out.writeLength(enc.length);
        out.write(enc);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)o).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        boolean periodAllowed = false;
        int i = identifier.length() - 1;
        while (i >= 2) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9') {
                periodAllowed = true;
            } else if (ch == '.') {
                if (!periodAllowed) {
                    return false;
                }
                periodAllowed = false;
            } else {
                return false;
            }
            --i;
        }
        return periodAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ASN1ObjectIdentifier fromOctetString(byte[] enc) {
        if (enc.length < 3) {
            return new ASN1ObjectIdentifier(enc);
        }
        int idx1 = enc[enc.length - 2] & 0xFF;
        int idx2 = enc[enc.length - 1] & 0x7F;
        ASN1ObjectIdentifier[][] aSN1ObjectIdentifierArray = cache;
        synchronized (cache) {
            ASN1ObjectIdentifier possibleMatch;
            ASN1ObjectIdentifier[] first = cache[idx1];
            if (first == null) {
                DERObjectIdentifier.cache[idx1] = new ASN1ObjectIdentifier[128];
                first = DERObjectIdentifier.cache[idx1];
            }
            if ((possibleMatch = first[idx2]) == null) {
                first[idx2] = new ASN1ObjectIdentifier(enc);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return first[idx2];
            }
            if (Arrays.areEqual(enc, possibleMatch.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return possibleMatch;
            }
            first = cache[idx1 = idx1 + 1 & 0xFF];
            if (first == null) {
                DERObjectIdentifier.cache[idx1] = new ASN1ObjectIdentifier[128];
                first = DERObjectIdentifier.cache[idx1];
            }
            if ((possibleMatch = first[idx2]) == null) {
                first[idx2] = new ASN1ObjectIdentifier(enc);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return first[idx2];
            }
            if (Arrays.areEqual(enc, possibleMatch.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return possibleMatch;
            }
            possibleMatch = first[idx2 = idx2 + 1 & 0x7F];
            if (possibleMatch == null) {
                first[idx2] = new ASN1ObjectIdentifier(enc);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return first[idx2];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (Arrays.areEqual(enc, possibleMatch.getBody())) {
                return possibleMatch;
            }
            return new ASN1ObjectIdentifier(enc);
        }
    }
}

