/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.copy;

import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1String;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1TaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.copy.StreamUtil;
import com.pandora.core.sign.bouncycastle.util.Arrays;
import com.pandora.core.sign.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DERBitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected byte[] data;
    protected int padBits;

    protected static int getPadBits(int bitString) {
        int val = 0;
        int i = 3;
        while (i >= 0) {
            if (i != 0) {
                if (bitString >> i * 8 != 0) {
                    val = bitString >> i * 8 & 0xFF;
                    break;
                }
            } else if (bitString != 0) {
                val = bitString & 0xFF;
                break;
            }
            --i;
        }
        if (val == 0) {
            return 7;
        }
        int bits = 1;
        while (((val <<= 1) & 0xFF) != 0) {
            ++bits;
        }
        return 8 - bits;
    }

    protected static byte[] getBytes(int bitString) {
        int bytes = 4;
        int i = 3;
        while (i >= 1) {
            if ((bitString & 255 << i * 8) != 0) break;
            --bytes;
            --i;
        }
        byte[] result = new byte[bytes];
        int i2 = 0;
        while (i2 < bytes) {
            result[i2] = (byte)(bitString >> i2 * 8 & 0xFF);
            ++i2;
        }
        return result;
    }

    public static DERBitString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERBitString) {
            return DERBitString.getInstance(o);
        }
        return DERBitString.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    protected DERBitString(byte data, int padBits) {
        this.data = new byte[1];
        this.data[0] = data;
        this.padBits = padBits;
    }

    public DERBitString(byte[] data, int padBits) {
        this.data = data;
        this.padBits = padBits;
    }

    public DERBitString(byte[] data) {
        this(data, 0);
    }

    public DERBitString(int value) {
        this.data = DERBitString.getBytes(value);
        this.padBits = DERBitString.getPadBits(value);
    }

    public DERBitString(ASN1Encodable obj) throws IOException {
        this.data = obj.toASN1Primitive().getEncoded("DER");
        this.padBits = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public int intValue() {
        int value = 0;
        int i = 0;
        while (i != this.data.length && i != 4) {
            value |= (this.data[i] & 0xFF) << 8 * i;
            ++i;
        }
        return value;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        byte[] bytes = new byte[this.getBytes().length + 1];
        bytes[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, bytes, 1, bytes.length - 1);
        out.writeEncoded(3, bytes);
    }

    @Override
    public int hashCode() {
        return this.padBits ^ Arrays.hashCode(this.data);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERBitString)) {
            return false;
        }
        DERBitString other = (DERBitString)o;
        return this.padBits == other.padBits && Arrays.areEqual(this.data, other.data);
    }

    @Override
    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string = bOut.toByteArray();
        int i = 0;
        while (i != string.length) {
            buf.append(table[string[i] >>> 4 & 0xF]);
            buf.append(table[string[i] & 0xF]);
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    static DERBitString fromOctetString(byte[] bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte padBits = bytes[0];
        byte[] data = new byte[bytes.length - 1];
        if (data.length != 0) {
            System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
        }
        return new DERBitString(data, (int)padBits);
    }

    static DERBitString fromInputStream(int length, InputStream stream) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int padBits = stream.read();
        byte[] data = new byte[length - 1];
        if (data.length != 0 && Streams.readFully(stream, data) != data.length) {
            throw new EOFException("EOF encountered in middle of BIT STRING");
        }
        return new DERBitString(data, padBits);
    }
}

