/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.copy;

import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Sequence;
import com.pandora.core.sign.bouncycastle.asn1.copy.DEROctetString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class BEROctetString
extends ASN1OctetString {
    private static final int MAX_LENGTH = 1000;
    private ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != octs.length) {
            try {
                DEROctetString o = (DEROctetString)octs[i];
                bOut.write(o.getOctets());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(String.valueOf(octs[i].getClass().getName()) + " found in input should only contain DEROctetString");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("exception converting octets " + e.toString());
            }
            ++i;
        }
        return bOut.toByteArray();
    }

    public BEROctetString(byte[] string) {
        super(string);
    }

    public BEROctetString(ASN1OctetString[] octs) {
        super(BEROctetString.toBytes(octs));
        this.octs = octs;
    }

    @Override
    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return new Enumeration(){
            int counter = 0;

            @Override
            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.octs.length;
            }

            public Object nextElement() {
                return BEROctetString.this.octs[this.counter++];
            }
        };
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        int i = 0;
        while (i < this.string.length) {
            int end = i + 1000 > this.string.length ? this.string.length : i + 1000;
            byte[] nStr = new byte[end - i];
            System.arraycopy(this.string, i, nStr, 0, nStr.length);
            vec.addElement(new DEROctetString(nStr));
            i += 1000;
        }
        return vec;
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    int encodedLength() throws IOException {
        int length = 0;
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            length += ((ASN1Encodable)e.nextElement()).toASN1Primitive().encodedLength();
        }
        return 2 + length + 2;
    }

    @Override
    public void encode(ASN1OutputStream out) throws IOException {
        out.write(36);
        out.write(128);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            out.writeObject((ASN1Encodable)e.nextElement());
        }
        out.write(0);
        out.write(0);
    }

    static BEROctetString fromSequence(ASN1Sequence seq) {
        ASN1OctetString[] v = new ASN1OctetString[seq.size()];
        Enumeration e = seq.getObjects();
        int index = 0;
        while (e.hasMoreElements()) {
            v[index++] = (ASN1OctetString)e.nextElement();
        }
        return new BEROctetString(v);
    }
}

