/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1;

import com.pandora.core.sign.bouncycastle.asn1.ASN1Integer;
import com.pandora.core.sign.bouncycastle.asn1.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.ASN1TaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.StreamUtil;
import com.pandora.core.sign.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends ASN1Primitive {
    byte[] bytes;

    public static ASN1Integer getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Integer) {
            return (ASN1Integer)obj;
        }
        if (obj instanceof DERInteger) {
            return new ASN1Integer(((DERInteger)obj).getValue());
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Integer)DERInteger.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERInteger) {
            return DERInteger.getInstance(o);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    public DERInteger(long value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DERInteger(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DERInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.bytes.length) + this.bytes.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    @Override
    public int hashCode() {
        int value = 0;
        int i = 0;
        while (i != this.bytes.length) {
            value ^= (this.bytes[i] & 0xFF) << i % 4;
            ++i;
        }
        return value;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERInteger)) {
            return false;
        }
        DERInteger other = (DERInteger)o;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

