/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign;

import com.pandora.core.plist.XMLPListParser;
import com.pandora.core.sign.bouncycastle.asn1.ASN1InputStream;
import com.pandora.core.sign.bouncycastle.asn1.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.cms.ContentInfo;
import com.pandora.core.sign.bouncycastle.asn1.cms.SignedData;
import com.pandora.core.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Map;

public class Mobileprovision {
    private String name;
    private String UUID;
    private String applicationIdentifier;
    private boolean supportApsEnvironment;
    private Certificate[] certificates;

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public boolean isSupportApsEnvironment() {
        return this.supportApsEnvironment;
    }

    public Mobileprovision(byte[] bytes) throws Exception {
        ContentInfo contentInfo = ContentInfo.getInstance(new ASN1InputStream(bytes).readObject());
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        byte[] plist = ((ASN1OctetString)signedData.getEncapContentInfo().getContent()).getOctets();
        Map<String, Object> map = new XMLPListParser().parse(plist);
        this.name = map.get("Name").toString();
        this.UUID = map.get("UUID").toString();
        Object applicationIdentifierPrefixs = map.get("ApplicationIdentifierPrefix");
        String applicationIdentifierPrefix = null;
        if (applicationIdentifierPrefixs instanceof ArrayList) {
            applicationIdentifierPrefix = (String)((ArrayList)applicationIdentifierPrefixs).get(0);
        }
        Map entitlements = (Map)map.get("Entitlements");
        this.applicationIdentifier = entitlements.get("application-identifier").toString();
        if (!StringUtil.isEmpty(applicationIdentifierPrefix) && this.applicationIdentifier.startsWith(applicationIdentifierPrefix)) {
            this.applicationIdentifier = this.applicationIdentifier.substring(applicationIdentifierPrefix.length() + 1);
        }
        this.supportApsEnvironment = entitlements.containsKey("aps-environment");
        ArrayList developerCertificates = (ArrayList)map.get("DeveloperCertificates");
        this.certificates = new Certificate[developerCertificates.size()];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        int index = 0;
        while (index < developerCertificates.size()) {
            byte[] certificateData = (byte[])developerCertificates.get(index);
            this.certificates[index] = certificateFactory.generateCertificate(new ByteArrayInputStream(certificateData));
            ++index;
        }
    }
}

