/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.wizards;

import com.pandora.refactor.core.RefactorCoreActivator;
import com.pandora.refactor.core.RenameResourceInfo;
import com.pandora.refactor.ui.ltk.ui.refactoring.UserInputWizardPage;
import com.pandora.refactor.ui.wizards.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameResourceInputPage
extends UserInputWizardPage {
    private static final String DS_KEY = RenameResourceInputPage.class.getName();
    private static final String DS_UPDATE_BUNDLE = "UPDATE_BUNDLE";
    private static final String DS_ALL_PROJECTS = "ALL_PROJECTS";
    private final RenameResourceInfo info;
    private IDialogSettings dialogSettings;
    private Text txtNewName;

    public RenameResourceInputPage(RenameResourceInfo info) {
        super(RenameResourceInputPage.class.getName());
        this.info = info;
        this.initDialogSettings();
    }

    private void initDialogSettings() {
        IDialogSettings ds = RefactorCoreActivator.getDefault().getDialogSettings();
        this.dialogSettings = ds.getSection(DS_KEY);
        if (this.dialogSettings == null) {
            this.dialogSettings = ds.addNewSection(DS_KEY);
            this.dialogSettings.put(DS_UPDATE_BUNDLE, true);
            this.dialogSettings.put(DS_ALL_PROJECTS, true);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = this.createRootComposite(parent);
        this.setControl((Control)composite);
        this.createLblNewName(composite);
        this.createTxtNewName(composite);
        this.validate();
    }

    private void validate() {
        String txt = this.txtNewName.getText();
        boolean isSure = this.info.getRefactorAction().isMakeSure();
        this.setPageComplete(txt.length() > 0 && !txt.equals(this.info.getOldName()));
        if (!isSure) {
            this.getRefactoringWizard().setForcePreviewReview(true);
        }
        this.info.setUpdateBundle(this.dialogSettings.getBoolean(DS_UPDATE_BUNDLE));
        this.info.setAllProjects(this.dialogSettings.getBoolean(DS_ALL_PROJECTS));
    }

    private void createTxtNewName(Composite composite) {
        this.txtNewName = new Text(composite, 2048);
        this.txtNewName.setText(this.info.getOldName());
        this.txtNewName.setLayoutData((Object)new GridData(768));
        this.txtNewName.selectAll();
        this.txtNewName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                RenameResourceInputPage.this.info.setNewName(RenameResourceInputPage.this.txtNewName.getText());
                RenameResourceInputPage.this.validate();
            }
        });
    }

    private void createLblNewName(Composite composite) {
        Label lblNewName = new Label(composite, 0);
        lblNewName.setText(Messages.RenameResourceInputPage_NewName);
    }

    private Composite createRootComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        result.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }
}

