/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.ltk.ui.refactoring;

import com.pandora.refactor.ui.ltk.internal.ui.refactoring.FinishResult;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.InternalAPI;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import com.pandora.refactor.ui.ltk.ui.refactoring.RefactoringWizard;
import com.pandora.refactor.ui.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class UserInputWizardPage
extends RefactoringWizardPage {
    private boolean fIsLastUserInputPage;

    public UserInputWizardPage(String name) {
        super(name);
    }

    public boolean isLastUserInputPage() {
        return this.fIsLastUserInputPage;
    }

    protected final IWizardPage computeSuccessorPage() {
        return this.getRefactoringWizard().computeUserInputSuccessorPage((IWizardPage)this, (IRunnableContext)this.getContainer());
    }

    public void setPageComplete(RefactoringStatus status) {
        this.getRefactoringWizard().setConditionCheckingStatus(status);
        int severity = status.getSeverity();
        if (severity == 4) {
            this.setPageComplete(false);
            this.setErrorMessage(status.getMessageMatchingSeverity(severity));
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            if (severity == 0) {
                this.setMessage(null, 0);
            } else {
                this.setMessage(status.getMessageMatchingSeverity(severity), UserInputWizardPage.getCorrespondingIStatusSeverity(severity));
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getRefactoringWizard().internalSetChange(InternalAPI.INSTANCE, null);
        }
        super.setVisible(visible);
    }

    public IWizardPage getNextPage() {
        if (this.fIsLastUserInputPage) {
            return this.computeSuccessorPage();
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        if (this.fIsLastUserInputPage) {
            return this.isPageComplete();
        }
        return super.canFlipToNextPage();
    }

    @Override
    protected boolean performFinish() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        int threshold = RefactoringCore.getConditionCheckingFailedSeverity();
        RefactoringStatus activationStatus = wizard.getInitialConditionCheckingStatus();
        RefactoringStatus inputStatus = null;
        RefactoringStatus status = new RefactoringStatus();
        Refactoring refactoring = this.getRefactoring();
        if (activationStatus != null && activationStatus.getSeverity() >= threshold) {
            if (!activationStatus.hasFatalError()) {
                inputStatus = wizard.checkFinalConditions();
            }
        } else {
            CreateChangeOperation create = new CreateChangeOperation(new CheckConditionsOperation(refactoring, 4), threshold);
            UIPerformChangeOperation perform = new UIPerformChangeOperation(this.getShell().getDisplay(), create, this.getContainer());
            FinishResult result = wizard.internalPerformFinish(InternalAPI.INSTANCE, perform);
            wizard.internalSetChange(InternalAPI.INSTANCE, create.getChange());
            if (result.isException()) {
                return true;
            }
            if (result.isInterrupted()) {
                return false;
            }
            inputStatus = new RefactoringStatus();
            inputStatus.merge(create.getConditionCheckingStatus());
            RefactoringStatus validationStatus = perform.getValidationStatus();
            if (validationStatus != null && validationStatus.hasFatalError()) {
                inputStatus.merge(perform.getValidationStatus());
            }
        }
        status.merge(activationStatus);
        status.merge(inputStatus);
        if (status.getSeverity() >= threshold) {
            wizard.setConditionCheckingStatus(status);
            IWizardPage nextPage = wizard.getPage("ErrorPage");
            wizard.getContainer().showPage(nextPage);
            return false;
        }
        return true;
    }

    void markAsLastUserInputPage() {
        this.fIsLastUserInputPage = true;
    }

    private static int getCorrespondingIStatusSeverity(int severity) {
        if (severity == 4) {
            return 4;
        }
        if (severity == 3) {
            return 2;
        }
        if (severity == 2) {
            return 2;
        }
        if (severity == 1) {
            return 1;
        }
        return 0;
    }
}

