/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.ltk.internal.ui.refactoring;

import com.pandora.refactor.ui.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.InternalLanguageElementNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.PreviewNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.RefactoringPluginImages;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.TextEditChangePreviewViewer;
import com.pandora.refactor.ui.ltk.ui.refactoring.TextEditChangeNode;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

public final class TextEditGroupNode
extends TextEditChangeNode.ChildNode {
    private TextEditBasedChangeGroup fChangeGroup;

    public TextEditGroupNode(PreviewNode parent, TextEditBasedChangeGroup changeGroup) {
        super(parent);
        this.fChangeGroup = changeGroup;
        Assert.isNotNull((Object)this.fChangeGroup);
    }

    TextEditBasedChangeGroup getChangeGroup() {
        return this.fChangeGroup;
    }

    @Override
    public String getText() {
        return this.fChangeGroup.getName();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_TEXT_EDIT;
    }

    @Override
    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    @Override
    void feedInput(IChangePreviewViewer viewer, List categories) throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextEditBasedChange) {
                IRegion range = TextEditGroupNode.getTextRange(this);
                ChangePreviewViewerInput input = null;
                input = range != null ? TextEditChangePreviewViewer.createInput(change, new TextEditBasedChangeGroup[]{this.fChangeGroup}, range) : TextEditChangePreviewViewer.createInput(change, this.fChangeGroup, 2);
                viewer.setInput(input);
            }
        } else {
            viewer.setInput(null);
        }
    }

    @Override
    void setEnabled(boolean enabled) {
        this.fChangeGroup.setEnabled(enabled);
    }

    @Override
    void setEnabledShallow(boolean enabled) {
        this.fChangeGroup.setEnabled(enabled);
    }

    @Override
    int getActive() {
        return this.fChangeGroup.isEnabled() ? 2 : 0;
    }

    @Override
    PreviewNode[] getChildren() {
        return PreviewNode.EMPTY_CHILDREN;
    }

    @Override
    boolean hasOneGroupCategory(List categories) {
        return this.fChangeGroup.getGroupCategorySet().containsOneCategory(categories);
    }

    @Override
    boolean hasDerived() {
        return false;
    }

    GroupCategorySet getGroupCategorySet() {
        return this.fChangeGroup.getGroupCategorySet();
    }

    private static IRegion getTextRange(PreviewNode element) throws CoreException {
        if (element == null) {
            return null;
        }
        if (element instanceof InternalLanguageElementNode) {
            return ((InternalLanguageElementNode)element).getTextRange();
        }
        if (element instanceof TextEditChangeNode) {
            return null;
        }
        return TextEditGroupNode.getTextRange(element.getParent());
    }
}

