/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.ltk.internal.ui.refactoring;

import com.pandora.refactor.core.refactoring.Messages;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.AbstractChangeNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.PreviewNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.RefactoringPluginImages;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class CompositeChangeNode
extends AbstractChangeNode {
    private final RefactoringPreviewChangeFilter fFilter;

    public CompositeChangeNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, CompositeChange change) {
        super(parent, (Change)change);
        this.fFilter = filter;
    }

    @Override
    int getActive() {
        return this.getCompositeChangeActive();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Change change = this.getChange();
        if (change instanceof CompositeChange) {
            String name = change.getName();
            if (Messages.RenameResourceDelegate_Rename_Undefine.equals(name)) {
                return RefactoringPluginImages.DESC_OBJS_REFACTORING_WARNING;
            }
            if (Messages.RenameResourceDelegate_Rename_Indefine.equals(name)) {
                return RefactoringPluginImages.DESC_OBJS_REFACTORING_INFO;
            }
        }
        return RefactoringPluginImages.DESC_OBJS_COMPOSITE_CHANGE;
    }

    @Override
    PreviewNode[] doCreateChildren() {
        ArrayList children = new ArrayList();
        this.getFlattendedChildren(children, this, (CompositeChange)this.getChange());
        return children.toArray(new PreviewNode[children.size()]);
    }

    private void getFlattendedChildren(List result, CompositeChangeNode parent, CompositeChange focus) {
        Change[] changes = focus.getChildren();
        int i = 0;
        while (i < changes.length) {
            Change change = changes[i];
            if (this.fFilter == null || this.fFilter.select(change)) {
                if (change instanceof CompositeChange && ((CompositeChange)change).isSynthetic()) {
                    this.getFlattendedChildren(result, parent, (CompositeChange)change);
                } else {
                    result.add(CompositeChangeNode.createNode(parent, change));
                }
            }
            ++i;
        }
    }
}

