/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.ltk.internal.ui.refactoring;

import com.pandora.refactor.ui.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.CompositeChangeNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.DefaultChangeNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.PreviewNode;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.RefactoringPluginImages;
import com.pandora.refactor.ui.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import com.pandora.refactor.ui.ltk.ui.refactoring.TextEditChangeNode;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

public abstract class AbstractChangeNode
extends PreviewNode {
    private final Change fChange;
    private PreviewNode[] fChildren;

    public static PreviewNode createNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, Change change) {
        if (change instanceof CompositeChange) {
            return new CompositeChangeNode(parent, filter, (CompositeChange)change);
        }
        if (change instanceof TextEditBasedChange) {
            TextEditChangeNode result = (TextEditChangeNode)change.getAdapter(TextEditChangeNode.class);
            if (result == null) {
                result = new TextEditChangeNode((TextEditBasedChange)change);
            }
            result.initialize(parent);
            return result;
        }
        return new DefaultChangeNode(parent, change);
    }

    public static PreviewNode createNode(PreviewNode parent, Change change) {
        return AbstractChangeNode.createNode(parent, null, change);
    }

    AbstractChangeNode(PreviewNode parent, Change change) {
        super(parent);
        Assert.isNotNull((Object)change);
        this.fChange = change;
    }

    Change getChange() {
        return this.fChange;
    }

    @Override
    PreviewNode[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.doCreateChildren();
        }
        return this.fChildren;
    }

    abstract PreviewNode[] doCreateChildren();

    @Override
    public String getText() {
        return this.fChange.getName();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_DEFAULT_CHANGE;
    }

    @Override
    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        return ChangePreviewViewerDescriptor.get(this.fChange);
    }

    @Override
    void feedInput(IChangePreviewViewer viewer, List categories) throws CoreException {
        viewer.setInput(new ChangePreviewViewerInput(this.fChange));
    }

    @Override
    void setEnabled(boolean enabled) {
        this.fChange.setEnabled(enabled);
    }

    @Override
    void setEnabledShallow(boolean enabled) {
        this.fChange.setEnabledShallow(enabled);
    }

    @Override
    boolean hasOneGroupCategory(List categories) {
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].hasOneGroupCategory(categories)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean hasDerived() {
        if (AbstractChangeNode.hasDerivedResourceChange(this.fChange)) {
            return true;
        }
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].hasDerived()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getDefaultChangeActive() {
        int result;
        int n = result = this.fChange.isEnabled() ? 2 : 0;
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
        }
        return result;
    }

    int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int result = this.fChildren[0].getActive();
            int i = 1;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
            return result;
        }
        return this.fChange.isEnabled() ? 2 : 0;
    }

    static boolean hasDerivedResourceChange(Change change) {
        IAdaptable adaptable;
        IResource resource;
        Object modifiedElement = change.getModifiedElement();
        if (modifiedElement instanceof IResource) {
            return ((IResource)modifiedElement).isDerived(512);
        }
        if (modifiedElement instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)modifiedElement).getAdapter(IResource.class)) != null) {
            return resource.isDerived(512);
        }
        return false;
    }
}

