/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.ui.action;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.pandora.refactor.core.IRefactorAction;
import com.pandora.refactor.core.RefactorAction;
import com.pandora.refactor.core.RenameResourceInfo;
import com.pandora.refactor.core.refactoring.RenameJSResourceProcessor;
import com.pandora.refactor.core.refactoring.RenameResourceRefactoring;
import com.pandora.refactor.ui.action.Messages;
import com.pandora.refactor.ui.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import com.pandora.refactor.ui.wizards.RenameJSResourceWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class RenameResourceAction
extends AbstractHandler
implements IEditorActionDelegate {
    private boolean onJavaScriptPatition;
    private ISelection selection;
    private AbstractThemeableEditor targetEditor;
    private RenameResourceInfo renameResourceInfo = new RenameResourceInfo();

    public void run(IAction action) {
        if (this.onJavaScriptPatition) {
            if (this.selection != null && this.selection instanceof ITextSelection) {
                this.applySelection((ITextSelection)this.selection);
                if (this.saveAll()) {
                    this.openWizard();
                }
            }
        } else {
            this.refuse();
        }
    }

    private void openWizard() {
        RenameJSResourceProcessor processor = new RenameJSResourceProcessor(this.renameResourceInfo);
        RenameResourceRefactoring renameResourceRefactoring = new RenameResourceRefactoring((RefactoringProcessor)processor);
        RenameJSResourceWizard wizard = new RenameJSResourceWizard(renameResourceRefactoring, this.renameResourceInfo);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
        try {
            String titleForFailedChecks = "Rename";
            op.run(this.getShell(), titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean saveAll() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return IDE.saveAllEditors((IResource[])new IResource[]{workspaceRoot}, (boolean)true);
    }

    private void applySelection(ITextSelection selection) {
        this.renameResourceInfo.setOffset(selection.getOffset());
        IRefactorAction refactorAction = RefactorAction.newRefactorAction((AbstractThemeableEditor)this.targetEditor, (ITextSelection)selection);
        this.renameResourceInfo.setRefactorAction(refactorAction);
        String parseNode = refactorAction.getSelectNode();
        if (StringUtil.isNotBlank((String)parseNode)) {
            this.renameResourceInfo.setNewName(parseNode);
            this.renameResourceInfo.setOldName(parseNode);
        } else {
            this.renameResourceInfo.setNewName(selection.getText());
            this.renameResourceInfo.setOldName(selection.getText());
        }
        this.renameResourceInfo.setSourceFile(this.getFile());
        this.renameResourceInfo.setSelection(selection);
        this.renameResourceInfo.setEditor(this.targetEditor);
    }

    private IFile getFile() {
        IFile result = null;
        IEditorInput input = this.targetEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            result = ((IFileEditorInput)input).getFile();
        }
        return result;
    }

    private void refuse() {
        String title = Messages.RenameResourceAction_Rename;
        String message = Messages.RenameResourceAction_TheResourceCanBeNotRename;
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
    }

    private Shell getShell() {
        Shell result = null;
        result = this.targetEditor != null ? this.targetEditor.getSite().getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart editor) {
        if (editor instanceof AbstractThemeableEditor) {
            this.targetEditor = (AbstractThemeableEditor)editor;
            this.onJavaScriptPatition = true;
            this.selectionChanged(null, this.targetEditor.getSelectionProvider().getSelection());
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        this.setActiveEditor(null, activePart);
        this.run(null);
        return null;
    }
}

