/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.browser.remote.debug.domain;

import com.pandora.browser.remote.debug.RemoteDebugActivator;
import com.pandora.browser.remote.debug.domain.AbstractDomain;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.core.log.HBLog;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;

public class Dom
extends AbstractDomain {
    public static String DOM_GETDOCUMENT = "DOM.getDocument";
    public static String DOM_QUERYSELECTOR = "DOM.querySelector";
    public static String DOM_HIGHLIGHTNODE = "DOM.highlightNode";
    public static String DOM_HIDEHIGHLIGHT = "DOM.hideHighlight";
    public static String DOM_SETINSPECTMODEENABLED = "DOM.setInspectModeEnabled";
    public static String DOM_RESOLVENODE = "DOM.resolveNode";
    public static String DOM_GETNODEFORLOCATION = "DOM.getNodeForLocation";
    public static String DOM_GETATTRIBUTES = "DOM.getAttributes";
    public static String DOM_REQUESTNODE = "DOM.requestNode";
    public static String DOM_REQUESTSHADOWHOSTDISTRIBUTEDNODES = "DOM.requestShadowHostDistributedNodes";
    private boolean inspectModeEnabled = false;
    private boolean highlightEnabled = false;

    public boolean highlight(final String selectorStr, final MessageListener messageRouter) {
        if (!this.checkClient()) {
            return false;
        }
        return this.remoteDebugClient.send(DOM_GETDOCUMENT, null, new MessageListener(){

            @Override
            public void receive(JSONObject response) {
                block5: {
                    try {
                        if (!response.has("root")) break block5;
                        JSONArray childrens = response.getJSONObject("root").getJSONArray("children");
                        int i = 0;
                        while (i < childrens.size()) {
                            JSONObject children = childrens.getJSONObject(i);
                            if (children.has("nodeType") && children.getInt("nodeType") == 1) {
                                int nodeId = children.getInt("nodeId");
                                if (children.has("nodeName") && selectorStr.equalsIgnoreCase(children.getString("nodeName"))) {
                                    Dom.this.highlight(nodeId, messageRouter);
                                }
                                Dom.this.remoteDebugClient.send(DOM_QUERYSELECTOR, new JSONObject().put("nodeId", nodeId).put("selector", (Object)selectorStr), new MessageListener(){

                                    @Override
                                    public void receive(JSONObject response) {
                                        if (response.has("nodeId")) {
                                            try {
                                                int nodeId = response.getInt("nodeId");
                                                Dom.this.highlight(nodeId, messageRouter);
                                            }
                                            catch (JSONException e) {
                                                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                                            }
                                        }
                                    }
                                });
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (JSONException e) {
                        HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                    }
                }
            }
        });
    }

    public boolean highlightFromObjectId(String objectId, MessageListener messageRouter) {
        block3: {
            try {
                if (this.checkClient() && objectId != null) break block3;
                return false;
            }
            catch (JSONException e) {
                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                return false;
            }
        }
        JSONObject params = new JSONObject();
        params.put("objectId", (Object)objectId);
        params.put("highlightConfig", (Map)this.getHighlightConfig());
        this.highlightEnabled = this.remoteDebugClient.send(DOM_HIGHLIGHTNODE, params, messageRouter);
        return this.highlightEnabled;
    }

    public boolean highlight(int nodeId, MessageListener messageRouter) {
        block3: {
            try {
                if (this.checkClient() && nodeId >= 0) break block3;
                return false;
            }
            catch (JSONException e) {
                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                return false;
            }
        }
        JSONObject params = new JSONObject();
        params.put("nodeId", nodeId);
        params.put("highlightConfig", (Map)this.getHighlightConfig());
        this.highlightEnabled = this.remoteDebugClient.send(DOM_HIGHLIGHTNODE, params, messageRouter);
        return this.highlightEnabled;
    }

    public boolean hideHighlight(MessageListener messageRouter) {
        this.highlightEnabled = false;
        if (!this.checkClient()) {
            return false;
        }
        return this.remoteDebugClient.send(DOM_HIDEHIGHLIGHT, null, messageRouter);
    }

    public boolean setInspectModeEnabled(boolean enable, MessageListener messageRouter) {
        if (!this.checkClient()) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("enabled", enable);
            params.put("highlightConfig", (Map)this.getHighlightConfig());
            boolean result = this.remoteDebugClient.send(DOM_SETINSPECTMODEENABLED, params, messageRouter);
            if (result) {
                this.inspectModeEnabled = enable;
            }
            return result;
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean resolveNode(int nodeId, String objectGroup, MessageListener messageRouter) {
        if (!this.checkClient()) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("nodeId", nodeId);
            if (objectGroup != null) {
                params.put("objectGroup", (Object)objectGroup);
            }
            return this.remoteDebugClient.send(DOM_RESOLVENODE, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean getNodeForLocation(int x, int y, MessageListener messageRouter) {
        if (!this.checkClient() || x < 0 || y <= 0) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("x", x);
            params.put("y", y);
            return this.remoteDebugClient.send(DOM_GETNODEFORLOCATION, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean getGetAttributes(int nodeId, MessageListener messageRouter) {
        if (!this.checkClient() || nodeId < 0) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("nodeId", nodeId);
            return this.remoteDebugClient.send(DOM_GETATTRIBUTES, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean requestNode(String objectId, MessageListener messageRouter) {
        if (!this.checkClient() || objectId == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("objectId", (Object)objectId);
            return this.remoteDebugClient.send(DOM_REQUESTNODE, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean requestShadowHostDistributedNodes(int nodeId, MessageListener messageRouter) {
        if (!this.checkClient() || nodeId < 0) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("nodeId", nodeId);
            return this.remoteDebugClient.send(DOM_REQUESTSHADOWHOSTDISTRIBUTEDNODES, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean isInspectModeEnabled() {
        return this.inspectModeEnabled && this.checkClient();
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled && this.checkClient();
    }

    public void resetDOMStatus() {
        try {
            this.highlightEnabled = false;
            if (!this.checkClient()) {
                return;
            }
            try {
                this.hideHighlight(null);
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            }
            if (this.inspectModeEnabled) {
                try {
                    this.setInspectModeEnabled(true, null);
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
        }
    }

    private JSONObject getHighlightConfig() throws JSONException {
        return new JSONObject("{\"showInfo\":true,\"contentColor\":{\"a\":0.4,\"b\":231,\"g\":196,\"r\":159},\"paddingColor\":{\"a\":0.4,\"b\":182,\"g\":221,\"r\":194},\"borderColor\":{\"a\":0.4,\"b\":187,\"g\":237,\"r\":254},\"marginColor\":{\"a\":0.4,\"b\":156,\"g\":203,\"r\":248}}");
    }
}

