/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.browser.remote.debug;

import com.pandora.browser.remote.debug.RemoteDebugActivator;
import com.pandora.browser.remote.debug.domain.Dom;
import com.pandora.browser.remote.debug.domain.Page;
import com.pandora.browser.remote.debug.domain.RunTime;
import com.pandora.browser.remote.debug.listener.IConnectionListener;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.core.log.HBLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.NotYetConnectedException;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class RemoteDebugClient {
    public static final String METHOD_DOM_INSPECTNODEREQUESTED = "DOM.inspectNodeRequested";
    private static RemoteDebugClient remoteProtocol;
    protected WebSocketClient wc;
    private int port = 9222;
    private Random random = new Random();
    private Dom dom = new Dom();
    private RunTime runTime = new RunTime();
    private Page page = new Page();
    private ConcurrentHashMap<Integer, MessageListener> messageRouters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<MessageListener>> methodNotifyListeners = new ConcurrentHashMap();
    private Set<IConnectionListener> connectionListeners = new HashSet<IConnectionListener>();

    public static RemoteDebugClient getInstence() {
        if (remoteProtocol == null) {
            remoteProtocol = new RemoteDebugClient();
        }
        return remoteProtocol;
    }

    public Dom getDom() {
        return this.dom;
    }

    public RunTime getRunTime() {
        return this.runTime;
    }

    public Page getPage() {
        return this.page;
    }

    public void addMethodNotifyListener(String method, MessageListener messageRouter) {
        if (method != null && messageRouter != null) {
            if (this.methodNotifyListeners.containsKey(method)) {
                this.methodNotifyListeners.get(method).add(messageRouter);
            } else {
                HashSet<MessageListener> set = new HashSet<MessageListener>();
                set.add(messageRouter);
                this.methodNotifyListeners.put(method, set);
            }
        }
    }

    public void removeMethodNotifyListener(String method, MessageListener messageRouter) {
        if (method != null && this.methodNotifyListeners.containsKey(method)) {
            this.methodNotifyListeners.get(method).remove(messageRouter);
        }
    }

    public void addConnectionListener(IConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListeners.add(connectionListener);
        }
    }

    public void removeConnectionListener(IConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListeners.remove(connectionListener);
        }
    }

    public boolean connect(int port) throws MalformedURLException, IOException, JSONException, URISyntaxException, InterruptedException {
        if (this.wc == null || !this.wc.isOpen() || this.port != port && port > 0) {
            String webSocketDebuggerUrl;
            block8: {
                if (this.wc != null && !this.wc.isClosed() && port > 0) {
                    this.wc.close();
                }
                this.dom.setRemoteDebugClient(this);
                this.runTime.setRemoteDebugClient(this);
                this.page.setRemoteDebugClient(this);
                if (port > 0) {
                    this.port = port;
                }
                URL u = new URL("http://localhost:" + this.port + "/json");
                HttpURLConnection uc = (HttpURLConnection)u.openConnection();
                uc.setReadTimeout(2000);
                uc.setConnectTimeout(2000);
                webSocketDebuggerUrl = null;
                try {
                    if (uc.getResponseCode() != 200) break block8;
                    String result = IOUtils.toString((InputStream)uc.getInputStream());
                    HBLog.logInfo((Plugin)RemoteDebugActivator.getDefault(), (String)("json <<< " + result));
                    JSONArray list = new JSONArray(result);
                    if (list.isEmpty()) break block8;
                    int i = 0;
                    while (i < list.length()) {
                        String url;
                        JSONObject node = list.getJSONObject(i);
                        if (node.has("url") && ((url = node.getString("url")) != null && url.contains("client/#hbuilder") || url.startsWith("chrome-devtools://")) || !node.has("webSocketDebuggerUrl") || (webSocketDebuggerUrl = node.getString("webSocketDebuggerUrl")) == null) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    return false;
                }
            }
            if (webSocketDebuggerUrl != null) {
                this.wc = new WebSocketClient(new URI(webSocketDebuggerUrl)){

                    public void onOpen(ServerHandshake handshakedata) {
                        RemoteDebugClient.this.messageRouters.clear();
                        HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (String)"----------remote open connect-----------");
                        try {
                            RemoteDebugClient.this.getDom().resetDOMStatus();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }

                    public void onMessage(String message) {
                        System.out.println("<<<|: " + message);
                        try {
                            JSONObject response = new JSONObject(message);
                            if (response.has("id") && response.has("result") && RemoteDebugClient.this.messageRouters.containsKey(response.getInt("id"))) {
                                MessageListener router = (MessageListener)RemoteDebugClient.this.messageRouters.remove(response.getInt("id"));
                                if (router != null) {
                                    router.receive(response.getJSONObject("result"));
                                }
                            } else if (response.has("method")) {
                                String method = response.getString("method");
                                if ("DOM.documentUpdated".equals(method)) {
                                    RemoteDebugClient.this.getDom().resetDOMStatus();
                                }
                                if (RemoteDebugClient.this.methodNotifyListeners.containsKey(method)) {
                                    Set set = (Set)RemoteDebugClient.this.methodNotifyListeners.get(method);
                                    for (MessageListener messageRouter : set) {
                                        messageRouter.receive(response);
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                        }
                    }

                    public void onError(Exception ex) {
                        HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (String)"----------remote connect error-----------", (Throwable)ex);
                    }

                    public void onClose(int code, String reason, boolean remote) {
                        HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (String)("----------remote close connect-----------" + code));
                        RemoteDebugClient.this.messageRouters.clear();
                        RemoteDebugClient.this.getDom().resetDOMStatus();
                    }
                };
                return this.wc.connectBlocking();
            }
        }
        return false;
    }

    public boolean send(String method, JSONObject params, MessageListener messageRouter) {
        if (this.wc == null || this.wc.isClosed()) {
            try {
                if (!this.connect(this.port)) {
                    return false;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
            if (this.wc == null || !this.wc.isOpen()) {
                return false;
            }
        }
        JSONObject request = new JSONObject();
        int id = this.createID();
        request.put("id", id).put("method", (Object)method);
        if (params != null) {
            request.put("params", (Map)params);
        }
        String message = request.toString();
        System.out.println("|>>> " + message);
        if (messageRouter != null) {
            this.messageRouters.put(id, messageRouter);
        }
        try {
            this.wc.send(message);
            return true;
        }
        catch (NotYetConnectedException e) {
            try {
                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                if (messageRouter != null) {
                    this.messageRouters.remove(id);
                }
            }
            catch (JSONException e2) {
                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e2);
            }
        }
        return false;
    }

    private int createID() {
        return this.random.nextInt(Integer.MAX_VALUE);
    }

    public boolean isOpen() {
        return this.wc != null && this.wc.isOpen();
    }

    public static void main(String[] args) throws Throwable {
        RemoteDebugClient.getInstence().connect(9223);
        Thread.sleep(2000L);
        RemoteDebugClient.getInstence().getRunTime().evaluate("HTMLDivElement.prototype.getHbuilderParentNodes=function(){if(this.parentNode&&this.nodeName&&this.nodeName!='#document'){var pn=this;var nodes=null;while(pn.nodeName&&pn.nodeName!='#document'){var name=pn.nodeName;var num=1;if(pn.parentNode){var childs=pn.parentNode.childNodes;if(childs&&childs.length>1){for(i=0;i<childs.length;i++){if(childs[i]===pn){break}if(childs[i].nodeName==pn.nodeName){num++}}}};name=(name+':'+(num-1));if(nodes){nodes=name+' '+nodes}else{nodes=name}pn=pn.parentNode}if(nodes){return nodes}}return null};", "hbuilder.realtime", new MessageListener(){

            @Override
            public void receive(JSONObject response) {
                RemoteDebugClient.getInstence().getDom().setInspectModeEnabled(true, null);
                MessageListener getParentNodes = new MessageListener(){

                    @Override
                    public void receive(JSONObject response) {
                        try {
                            int nodeId = response.getJSONObject("params").getInt("nodeId");
                            RemoteDebugClient.getInstence().getDom().resolveNode(nodeId, "hbuilder.realtime", new MessageListener(){

                                @Override
                                public void receive(JSONObject response) {
                                    if (response.has("object")) {
                                        try {
                                            JSONObject object = response.getJSONObject("object");
                                            if (object.has("className") && object.getString("className").endsWith("Element")) {
                                                String objectId = object.getString("objectId");
                                                RemoteDebugClient.getInstence().getRunTime().callFunctionOn(objectId, "getHbuilderParentNodes", new MessageListener(){

                                                    @Override
                                                    public void receive(JSONObject response) {
                                                        System.out.println(response);
                                                    }
                                                });
                                            }
                                        }
                                        catch (JSONException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            });
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                };
                RemoteDebugClient.getInstence().addMethodNotifyListener(RemoteDebugClient.METHOD_DOM_INSPECTNODEREQUESTED, getParentNodes);
            }
        });
    }
}

