/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter.preferences;

import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.formatter.preferences.Messages;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class HTMLFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private static final String INDENTATION_PREVIEW_FILE = "indentation-preview.html";
    private final String[] tabOptionItems = new String[]{"space", "tab", "editor"};
    private final String[] tabOptionNames = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public HTMLFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.HTMLFormatterIndentationTabPage_indentationGeneralGroupLabel, (int)2, (int)1, (int)768);
        Combo tabOptions = manager.createCombo((Composite)group, (Object)"html.formatter.formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabOptionItems, this.tabOptionNames);
        Text indentationSize = manager.createNumber((Composite)group, "html.formatter.formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size, 1);
        new TabOptionHandler(manager, tabOptions, indentationSize);
        group = SWTFactory.createGroup((Composite)parent, (String)"\u6807\u7b7e\u5185\u7f29\u8fdb", (int)2, (int)1, (int)768);
        manager.createCheckbox((Composite)group, (Object)"html.formatter.indent.html", "H&TML\u5b50\u6807\u7b7e\u662f\u5426\u7f29\u8fdb", 2);
        manager.createCheckbox((Composite)group, (Object)"html.formatter.indent.head", "He&ad\u5b50\u6807\u7b7e\u662f\u5426\u7f29\u8fdb", 2);
        manager.createCheckbox((Composite)group, (Object)"html.formatter.indent.body", "&Body\u5b50\u6807\u7b7e\u662f\u5426\u7f29\u8fdb", 2);
        manager.createCombo((Composite)group, (Object)"html.formatter.indent.script", "&Script\u3001Style\u5185\u7f29\u8fdb\u7b56\u7565", new String[]{"normal", "keep", "separate"}, new String[]{"\u6b63\u5e38\u7f29\u8fdb", "\u4e0e\u6807\u7b7e\u5e73\u9f50", "\u4e0e\u884c\u9996\u5e73\u9f50"});
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(INDENTATION_PREVIEW_FILE);
    }

    private class TabOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;
        private Combo tabOptions;
        private Text indentationSize;

        public TabOptionHandler(IFormatterControlManager controlManager, Combo tabOptions, Text indentationSize) {
            this.manager = controlManager;
            this.tabOptions = tabOptions;
            this.indentationSize = indentationSize;
            tabOptions.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.tabOptions.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(HTMLFormatterIndentationTabPage.this.tabOptionItems[index]);
                boolean editorSettingsMode = "editor".equals(HTMLFormatterIndentationTabPage.this.tabOptionItems[index]);
                this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
                if (editorSettingsMode) {
                    HTMLFormatterIndentationTabPage.this.setEditorTabWidth(HTMLPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"html.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"html.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
            if (editorSettingsMode) {
                HTMLFormatterIndentationTabPage.this.setEditorTabWidth(HTMLPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
            }
        }
    }
}

