/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import at.jta.Key;
import at.jta.RegistryErrorException;
import at.jta.Regor;
import com.pandora.core.CoreActivator;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.LoginUtils;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileSystemView;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUtil {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String REG_PATH = "Software\\HBuilder\\{0}";
    private static final String VALUE_NAME = "WorkSpace";
    public static String HBUILDER_PROJECTS = "\\HBuilderProjects";
    public static final String HBUILDER_LIBRARY = "/Library/HBuilder";
    public static String USER_DOCUMENT_DIR = null;
    public static String USER_PROFILES_DIR = null;

    static {
        if (PlatformUtil.isMac()) {
            HBUILDER_PROJECTS = "/HBuilderProjects";
        }
    }

    public static String getCodeLocation() {
        String location = String.valueOf(WorkspaceUtil.getUserDocumentDir()) + HBUILDER_PROJECTS;
        File file = new File(location);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return location;
    }

    public static String getUserProfilesDir() {
        if (StringUtil.isNotBlank((String)USER_PROFILES_DIR)) {
            return USER_PROFILES_DIR;
        }
        USER_PROFILES_DIR = PlatformUtil.isWindows() ? String.valueOf(System.getenv().get("APPDATA")) + "/HBuilder/userprofiles/" : String.valueOf(System.getenv().get("HOME")) + "/HBuilder/userprofiles/";
        return USER_PROFILES_DIR;
    }

    public static List<String> getUsers() {
        File userfile;
        File hbuilderUserDir;
        if (PlatformUtil.isWindows()) {
            ArrayList<String> userlist;
            block23: {
                userlist = new ArrayList<String>();
                Regor regor = null;
                Key key = null;
                try {
                    try {
                        regor = new Regor();
                        key = regor.openKey(Regor.HKEY_CURRENT_USER, "Software\\HBuilder", 131097);
                        if (key != null) {
                            List tmplist = regor.listKeys(key);
                            for (Object k : tmplist) {
                                userlist.add(k.toString());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (regor != null && key != null) {
                            try {
                                regor.closeKey(key);
                            }
                            catch (RegistryErrorException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (regor != null && key != null) {
                        try {
                            regor.closeKey(key);
                        }
                        catch (RegistryErrorException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (regor != null && key != null) {
                    try {
                        regor.closeKey(key);
                    }
                    catch (RegistryErrorException e) {
                        e.printStackTrace();
                    }
                }
            }
            return userlist;
        }
        ArrayList<String> userlist = new ArrayList<String>();
        String tmppath = System.getenv().get("HOME");
        File hbuilderDir = new File(String.valueOf(tmppath) + "/HBuilder");
        if (!hbuilderDir.exists()) {
            hbuilderDir.mkdir();
        }
        if (!(hbuilderUserDir = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User")).exists()) {
            hbuilderUserDir.mkdir();
        }
        if (!(userfile = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User/HBuilderConfig.plist")).exists()) {
            return null;
        }
        SAXReader sr = new SAXReader();
        try {
            Document doc = sr.read(userfile);
            Element arraynode = doc.getRootElement().element("dict").element("array");
            List emailist = arraynode.elements();
            for (Element e : emailist) {
                userlist.add(e.getText());
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            return null;
        }
        return userlist;
    }

    public static String getUserDocumentDir() {
        if (StringUtil.isNotBlank((String)USER_DOCUMENT_DIR)) {
            return USER_DOCUMENT_DIR;
        }
        try {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            USER_DOCUMENT_DIR = fsv.getDefaultDirectory().getPath();
        }
        catch (Exception exception) {
            USER_DOCUMENT_DIR = String.valueOf(System.getProperty("user.home")) + File.separatorChar + "Documents";
        }
        return USER_DOCUMENT_DIR;
    }

    public static void moveCodeDirProjects(String oldCodeDir, String newCodeDir, IProgressMonitor monitor) {
        File oldCodeDirFile = new File(oldCodeDir);
        if (!oldCodeDirFile.exists() || oldCodeDirFile.list().length == 0) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)oldCodeDirFile.list().length);
        File[] fileArray = oldCodeDirFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File project = fileArray[n2];
            File[] children = project.listFiles();
            sub.worked(1);
            if (children != null) {
                IWorkspaceRoot root;
                IProject pro;
                boolean isProject = false;
                File[] fileArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    File child = fileArray2[n4];
                    if (child.getName().equals(".project")) {
                        isProject = true;
                        break;
                    }
                    ++n4;
                }
                if (isProject && (pro = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(project.getName())) != null && pro.exists()) {
                    try {
                        sub.setTaskName("\u6b63\u5728\u79fb\u52a8" + project.getName() + "\u9879\u76ee...");
                        IProjectDescription oldDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(pro.getLocation().append(".project"));
                        oldDescription.setLocation(new Path(newCodeDir).append(pro.getName()));
                        pro.move(oldDescription, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        sub.done();
    }

    public static void moveWorkspaceProjects(String newCodeDir, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        if (projects == null || projects.length == 0) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                sub.setTaskName("\u6b63\u5728\u79fb\u52a8" + project.getName() + "\u9879\u76ee...");
                sub.worked(1);
                IProjectDescription oldDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(project.getLocation().append(".project"));
                oldDescription.setLocation(new Path(newCodeDir).append(project.getName()));
                project.move(oldDescription, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        sub.done();
    }

    public static void moveTo(String oldCodeDir, IProgressMonitor monitor) {
    }

    public static String getCodeDir(String userName) {
        if (LoginUtils.OFFLINE_USERNAME.equals(userName)) {
            if (PlatformUtil.isWindows()) {
                FileSystemView fsv = FileSystemView.getFileSystemView();
                String tmpcodedir = String.valueOf(fsv.getDefaultDirectory().getPath()) + "\\HBuilderProjects";
                File tmpFile = new File(tmpcodedir);
                if (!tmpFile.exists()) {
                    tmpFile.mkdir();
                }
                return tmpcodedir;
            }
            String tmpdir = String.valueOf(System.getProperty("user.home")) + "/HBuilderProjects";
            File tmpFile = new File(tmpdir);
            if (!tmpFile.exists()) {
                tmpFile.mkdir();
            }
        }
        String codeLocation = WorkspaceUtil.getCodeLocation();
        if (StringUtil.isEmpty((String)userName)) {
            return codeLocation;
        }
        if (PlatformUtil.isWindows()) {
            String regPath = MessageFormat.format(REG_PATH, userName);
            Regor regor = null;
            Key key = null;
            try {
                regor = new Regor();
                key = regor.openKey(Regor.HKEY_CURRENT_USER, regPath, 131097);
                if (key == null) {
                    FileSystemView fsv = FileSystemView.getFileSystemView();
                    String tmpcodedir = String.valueOf(fsv.getDefaultDirectory().getPath()) + "\\HBuilderProjects";
                    File tmpFile = new File(tmpcodedir);
                    if (!tmpFile.exists()) {
                        tmpFile.mkdir();
                    }
                    String string = tmpcodedir;
                    return string;
                }
                byte[] values = regor.readValue(key, VALUE_NAME);
                String codedir = "";
                if (values != null && values.length > 0) {
                    codedir = StringUtil.parseValue((byte[])values);
                }
                if (codedir == null || "".equals(codedir)) {
                    codedir = codeLocation;
                }
                if (StringUtil.isBlank((String)codedir)) {
                    FileSystemView fsv = FileSystemView.getFileSystemView();
                    String tmpcodedir = String.valueOf(fsv.getDefaultDirectory().getPath()) + "\\HBuilderProjects";
                    File tmpFile = new File(tmpcodedir);
                    if (!tmpFile.exists()) {
                        tmpFile.mkdir();
                    }
                    String string = tmpcodedir;
                    return string;
                }
                String string = codedir;
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (regor != null && key != null) {
                    try {
                        regor.closeKey(key);
                    }
                    catch (RegistryErrorException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        File workspaceFile = WorkspaceUtil.getLibraryFileByUsername(userName);
        if (!workspaceFile.exists()) {
            return codeLocation;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(workspaceFile);
            String codedir = IOUtil.read((InputStream)inputStream);
            if (StringUtil.isBlank((String)codedir)) {
                String string = codeLocation;
                return string;
            }
            String string = codedir;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = codeLocation;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static int setNewCodeDir(String userName, String newCodeDir) {
        if (StringUtil.isEmpty((String)userName) || StringUtil.isEmpty((String)newCodeDir)) {
            return -1;
        }
        if (PlatformUtil.isWindows()) {
            String regPath = MessageFormat.format(REG_PATH, userName);
            Regor regor = null;
            Key key = null;
            try {
                regor = new Regor();
                key = regor.openKey(Regor.HKEY_CURRENT_USER, regPath, 131078);
                Field field = regor.getClass().getDeclaredField("setValue");
                regor.deleteEntry(key, VALUE_NAME);
                if (field != null) {
                    field.setAccessible(true);
                    Method method = (Method)field.get(regor);
                    method.invoke(null, new Integer(key.getKey()), VALUE_NAME.getBytes(), newCodeDir.getBytes("gbk"));
                } else {
                    regor.saveValue(key, VALUE_NAME, newCodeDir);
                }
                regor.flushKey(key);
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (regor != null && key != null) {
                    try {
                        regor.closeKey(key);
                    }
                    catch (RegistryErrorException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        FileOutputStream outStream = null;
        try {
            File workspaceFile = WorkspaceUtil.getLibraryFileByUsername(userName);
            if (!workspaceFile.exists()) {
                workspaceFile.createNewFile();
            }
            outStream = new FileOutputStream(workspaceFile);
            IOUtil.write((OutputStream)outStream, (String)newCodeDir);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return -1;
    }

    private static File getLibraryFileByUsername(String userName) {
        String userLibrary;
        File userLibraryDir;
        String hbLibrary = String.valueOf(WorkspaceUtil.getUserDocumentDir()) + HBUILDER_LIBRARY;
        File libraryDir = new File(hbLibrary);
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            libraryDir.mkdirs();
        }
        if (!(userLibraryDir = new File(userLibrary = String.valueOf(hbLibrary) + "/" + userName)).exists() || !userLibraryDir.isDirectory()) {
            userLibraryDir.mkdir();
        }
        String workspace = String.valueOf(userLibrary) + "/" + VALUE_NAME;
        File workspaceFile = new File(workspace);
        return workspaceFile;
    }

    public static List<String> getLoginedUsers() {
        new ArrayList();
        try {
            Regor regor = new Regor();
            Key key = regor.openKey(Regor.HKEY_CURRENT_USER, "Software\\HBuilder", 131097);
            List<String> keylist = regor.listKeys(key);
            if (keylist == null) {
                keylist = Collections.emptyList();
            }
            return keylist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<IProject> importProjectsFromDir(String path, boolean delMetadata) {
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        File directory = new File(path);
        if (!directory.isDirectory()) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        if (!WorkspaceUtil.collectProjectFilesFromDirectory(files, directory, null)) {
            return null;
        }
        ArrayList<IProject> list = new ArrayList<IProject>();
        Iterator filesIterator = files.iterator();
        ProjectRecord[] selectedProjects = new ProjectRecord[files.size()];
        int index = 0;
        while (filesIterator.hasNext()) {
            File file = (File)filesIterator.next();
            selectedProjects[index] = new ProjectRecord(file);
            ++index;
        }
        int i = 0;
        while (i < selectedProjects.length) {
            try {
                IProject porject = WorkspaceUtil.createExistingProject(selectedProjects[i]);
                if (porject != null) {
                    list.add(porject);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (delMetadata) {
            try {
                File metadata = new File(path, METADATA_FOLDER);
                if (metadata.exists() && !directory.equals(ResourcesPlugin.getWorkspace().getRoot().getFullPath().toFile())) {
                    FileUtil.deleteRecursively((File)metadata);
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    private static IProject createExistingProject(ProjectRecord record) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return null;
        }
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        try {
            project.create(record.description, (IProgressMonitor)new NullProgressMonitor());
            project.open(128, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        return project;
    }

    private static boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited) {
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException iOException) {}
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block11: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block10: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block10;
                            break block11;
                        }
                        catch (IOException iOException) {}
                    }
                    WorkspaceUtil.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited);
                }
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        File[] files = File.listRoots();
        System.out.println(new File("asdfds").isAbsolute());
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            System.out.println(file.toURI().getSchemeSpecificPart());
            ++n2;
        }
    }

    private static class ProjectRecord {
        File projectSystemFile;
        String projectName;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

