/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.CoreActivator;
import com.pandora.core.auth.ProxyListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.proxy.Proxy;
import com.pandora.core.utils.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.runtime.Plugin;

public class ProxyUtils {
    public static Set<ProxyListener> listeners = new HashSet<ProxyListener>();
    private static final String DIRECT_PROVIDER = "Direct";
    private static final String ECLIPSE_PROVIDER = "Manual";
    private static final String NATIVE_PROVIDER = "Native";
    public static final String PROXY_NONE = "ProxyNone";
    public static final String PROXY_IE = "ProxyIE";
    public static final String PROXY_USER = "ProxyUser";

    public static void addProxyListener(ProxyListener listener) {
        listeners.add(listener);
    }

    public static void initProxy(boolean needUpdate) {
        for (ProxyListener listener : listeners) {
            String proxyJson = listener.getProxyInfo();
            if (!StringUtil.isNotBlank((String)proxyJson)) continue;
            try {
                JSONObject jsonobject = new JSONObject(proxyJson);
                String ip = jsonobject.getString("ProxyAddress");
                String port = jsonobject.getString("Port");
                String type = jsonobject.getString("ProxyType");
                if (StringUtil.isBlank((String)type) || PROXY_NONE.equals(type) || StringUtil.isBlank((String)ip) || StringUtil.isBlank((String)port)) continue;
                try {
                    Integer.valueOf(port);
                }
                catch (NumberFormatException e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (String)e.getMessage());
                    continue;
                }
                String username = "";
                String password = "";
                if (PROXY_USER.equals(type)) {
                    username = jsonobject.getString("ProxyUserName");
                    password = jsonobject.getString("ProxyPassWord");
                    if (StringUtil.isBlank((String)username) && StringUtil.isNotBlank((String)password)) continue;
                }
                Proxy.initProxy(Proxy.HTTP_TYPE, username, password, ip, port);
                if (!needUpdate) continue;
                ProxyUtils.updateUpdateProxy(type, username, password, ip, port);
            }
            catch (JSONException e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (String)e.getMessage());
            }
        }
    }

    public static void updateUpdateProxy(String type, String username, String password, String ip, String port) {
        String provider = DIRECT_PROVIDER;
        if (PROXY_IE.equals(type)) {
            provider = NATIVE_PROVIDER;
        } else if (PROXY_USER.equals(type)) {
            provider = ECLIPSE_PROVIDER;
            ProxyData httpProxyData = new ProxyData(Proxy.HTTP_TYPE, ip, Integer.valueOf(port).intValue(), true, provider);
            httpProxyData.setUserid(username);
            httpProxyData.setPassword(password);
            ProxyData httpsProxyData = new ProxyData(Proxy.HTTPS_TYPE, null, -1, false, provider);
            ProxyData socksProxyData = new ProxyData(Proxy.SOCKS_TYPE, null, -1, false, provider);
            ProxyData[] data = new ProxyData[]{httpProxyData, httpsProxyData, socksProxyData};
            ProxySelector.setProxyData((String)provider, (ProxyData[])data);
        }
        ProxySelector.setActiveProvider((String)provider);
    }

    public static void setProxyType(String pType) {
        for (ProxyListener listener : listeners) {
            listener.setProxyType(pType);
        }
        ProxyUtils.initProxy(false);
    }

    public static void setUserProxyInfo(String pUserName, String sPassword, String pProxyAddress, String pPort) {
        for (ProxyListener listener : listeners) {
            listener.setUserProxyInfo(pUserName, sPassword, pProxyAddress, pPort);
        }
        ProxyUtils.initProxy(false);
    }
}

