/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.CoreActivator;
import com.pandora.core.JavaScriptVersion;
import com.pandora.core.exception.ConvertProjectException;
import com.pandora.core.log.HBLog;
import com.pandora.core.project.HMobileConvertor;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.Messages;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectUtils {
    private static final QualifiedName JAVASCRIPT_VERSION_KEY = new QualifiedName("com.pandora.project", "javascript_version");

    public static HMobileProject convertToHMobile(IProject project) throws ConvertProjectException {
        return HMobileConvertor.convert(project);
    }

    public static IPath getSourceRoot(IProject project) {
        if (project == null) {
            return null;
        }
        return project.getLocation();
    }

    public static IProject getCurrentProject() {
        Object element;
        Object object;
        final ArrayList selectionServices = new ArrayList();
        final ArrayList editorParts = new ArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null) {
                    return;
                }
                selectionServices.add(workbenchWindow.getSelectionService());
                if (workbenchWindow.getActivePage() != null) {
                    editorParts.add(workbenchWindow.getActivePage().getActiveEditor());
                }
            }
        });
        ISelectionService selectionService = (ISelectionService)selectionServices.get(0);
        IEditorPart part = (IEditorPart)editorParts.get(0);
        ISelection selection = selectionService == null ? null : selectionService.getSelection();
        ISelection viewsSelection = selectionService == null ? null : selectionService.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        IProject project = null;
        if (selection instanceof ITextSelection && part != null && (object = part.getEditorInput().getAdapter(IFile.class)) != null && (project = ((IFile)object).getProject()) != null) {
            return project;
        }
        if (viewsSelection instanceof IStructuredSelection && !viewsSelection.isEmpty() && (element = ((IStructuredSelection)viewsSelection).getFirstElement()) instanceof IResource && (project = ((IResource)element).getProject()) != null) {
            return project;
        }
        if ((selection == null || selection.isEmpty()) && (viewsSelection == null || viewsSelection.isEmpty()) && part != null && (object = part.getEditorInput().getAdapter(IFile.class)) != null && (project = ((IFile)object).getProject()) != null) {
            return project;
        }
        return null;
    }

    public static void setAppid(IProject project, String appid) throws CoreException {
        try {
            HMobileProject hMobileProject = HMobileConvertor.convert(project);
            hMobileProject.setAppid(appid);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.pandora.core", e.getMessage()));
        }
    }

    public static String getAppid(IProject project) {
        try {
            HMobileProject hMobileproject = HMobileConvertor.convert(project);
            return hMobileproject.getAppid();
        }
        catch (ConvertProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<IProject> getProjectsByNature(String natureId, boolean includeOpen) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = wsroot.getProjects();
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen() || includeOpen) {
                    try {
                        IProjectNature projectNature = project.getNature(natureId);
                        if (projectNature != null) {
                            result.add(project);
                        }
                    }
                    catch (CoreException e) {
                        HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static List<HMobileProject> getHMobileProjects(boolean includeOpen) {
        List<IProject> projects = ProjectUtils.getProjectsByNature("com.pandora.projects.ui.MKeyNature", includeOpen);
        ArrayList<HMobileProject> hMobileProjects = new ArrayList<HMobileProject>();
        for (IProject project : projects) {
            try {
                hMobileProjects.add(ProjectUtils.convertToHMobile(project));
            }
            catch (ConvertProjectException e) {
                e.printStackTrace();
            }
        }
        return hMobileProjects;
    }

    public static IStatus getHMobileProjectStatus(IProject project) {
        try {
            HMobileProject hMobileProject = HMobileConvertor.convert(project);
            return hMobileProject.getStatus();
        }
        catch (ConvertProjectException e) {
            e.printStackTrace();
            return new Status(4, "com.pandora.core", Messages.ProjectUtils_GetStatusOfProject);
        }
    }

    public static List<String> getFilePathList(IPath path, IPath relativePath) {
        ArrayList<String> results = new ArrayList<String>();
        if (path != null) {
            File file = path.makeAbsolute().toFile();
            File relativeFile = relativePath.makeAbsolute().toFile();
            if (file.exists()) {
                if (file.isFile()) {
                    String result = file.getAbsolutePath().substring(relativeFile.getAbsolutePath().length());
                    results.add(result.replace("\\\\", "/"));
                } else {
                    ProjectUtils.infererFilePath(results, file, relativeFile);
                }
            }
        }
        return results;
    }

    private static void infererFilePath(List<String> results, File file, File relativeFile) {
        File[] files;
        File[] fileArray = files = file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                String result = f.getAbsolutePath().substring(relativeFile.getAbsolutePath().length());
                results.add(result.replaceAll("\\\\", "/"));
            } else {
                ProjectUtils.infererFilePath(results, f, relativeFile);
            }
            ++n2;
        }
    }

    public static void setJavaScriptVersion(IProject project, int version) {
        if (project != null) {
            try {
                project.setPersistentProperty(JAVASCRIPT_VERSION_KEY, String.valueOf(version));
            }
            catch (Exception e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
    }

    public static JavaScriptVersion getJavaScriptVersion(IProject project) {
        if (project != null) {
            try {
                String version = project.getPersistentProperty(JAVASCRIPT_VERSION_KEY);
                if (StringUtil.isNotEmpty((String)version)) {
                    int index = Integer.parseInt(version);
                    return JavaScriptVersion.indexOf(index);
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
        return JavaScriptVersion.ECMASCRIPT5_1;
    }
}

