/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.CoreActivator;
import com.pandora.core.IUserStatusListener;
import com.pandora.core.auth.ChangePWDListener;
import com.pandora.core.auth.LoginListener;
import com.pandora.core.log.HBLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class LoginUtils {
    public static Set<LoginListener> listeners = new HashSet<LoginListener>();
    public static Set<ChangePWDListener> changePWDListeners = new HashSet<ChangePWDListener>();
    private static Set<IUserStatusListener> userStatusListeners = new HashSet<IUserStatusListener>();
    public static String OFFLINE_USERNAME = "offline";
    public static String OFFLINE_USER_SHOWNAME = "\u767b\u5f55";

    public static void addReLoginListener(LoginListener listener) {
        listeners.add(listener);
    }

    public static void addChangePWDListener(ChangePWDListener listener) {
        changePWDListeners.add(listener);
    }

    public static void fireReloginEvent(boolean result) {
        for (LoginListener listener : listeners) {
            listener.login(result);
        }
    }

    public static String changePWD(String email, String oldPWD, String newPWD, String token) {
        Iterator<ChangePWDListener> iterator = changePWDListeners.iterator();
        if (iterator.hasNext()) {
            ChangePWDListener listener = iterator.next();
            return listener.changePWD(email, oldPWD, newPWD, token);
        }
        return null;
    }

    public static int saveDefaultUserInfo(String email, String pwd, String codedir) {
        Iterator<ChangePWDListener> iterator = changePWDListeners.iterator();
        if (iterator.hasNext()) {
            ChangePWDListener listener = iterator.next();
            return listener.saveDefaultUserAccount(email, pwd, codedir);
        }
        return 0;
    }

    public static String getPassword() {
        Iterator<ChangePWDListener> iterator = changePWDListeners.iterator();
        if (iterator.hasNext()) {
            ChangePWDListener listener = iterator.next();
            return listener.getPWD();
        }
        return null;
    }

    public static boolean addUserStatusListeners(IUserStatusListener listener) {
        return userStatusListeners.add(listener);
    }

    public static boolean removeUserStatusListeners(IUserStatusListener listener) {
        return userStatusListeners.remove(listener);
    }

    public static void notifyLoginStatus() {
        if (userStatusListeners != null && !userStatusListeners.isEmpty()) {
            for (IUserStatusListener listener : userStatusListeners) {
                try {
                    listener.updatestatus();
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                }
            }
        }
    }
}

