/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.auth.UserAuthService;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.ZipUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class CrashUtil {
    static boolean isCrash;
    static File creashFile;

    public static void checkCrashFile() {
        new Thread("check Crash Thread"){

            @Override
            public void run() {
                try {
                    File crashFile = CrashUtil.initCrashFile();
                    Properties p = null;
                    if (crashFile.exists()) {
                        try {
                            InputStreamReader in = null;
                            p = new Properties();
                            try {
                                in = new InputStreamReader((InputStream)new FileInputStream(crashFile), "utf-8");
                                p.load(in);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((Reader)in);
                            HttpClientUtils http = HttpClientUtils.getInstance("Crash!Collect");
                            Enumeration<?> e = p.propertyNames();
                            while (e.hasMoreElements()) {
                                String key = (String)e.nextElement();
                                http.addRequestBody(key, p.getProperty(key));
                            }
                            File logFile = new File(System.getProperty("osgi.logfile"));
                            File zipFile = new File(logFile.getParent(), "log.zip");
                            if (logFile.exists() && logFile.isFile()) {
                                ZipUtils.zip(logFile.getAbsolutePath(), zipFile.getAbsolutePath());
                                http.addFileBody("logFile", zipFile);
                            }
                            http.excute(false, false);
                            zipFile.delete();
                        }
                        catch (Exception e) {
                            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                        }
                    }
                    p = new Properties();
                    p.setProperty("account", UserAuth.isLoginSucess() == -2 ? UserAuth.getToken() : UserAuth.getUsername());
                    p.setProperty("osVersion", PlatformUtil.getOSVersion());
                    String mac = UserAuthService.getMAC();
                    if (mac != null) {
                        p.setProperty("mac", mac.split(",")[0]);
                    }
                    p.setProperty("hbVersion", ProductUtils.getProductVersion());
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(crashFile), "utf-8"));
                        p.store(out, null);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Writer)out);
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                }
            }
        }.start();
    }

    public static void deleteCrashFile() {
        try {
            File crashFile = CrashUtil.initCrashFile();
            if (crashFile.exists()) {
                crashFile.delete();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    private static File initCrashFile() throws IOException {
        if (creashFile != null) {
            return creashFile;
        }
        String installLocation = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)Platform.getInstallLocation().getURL()));
        creashFile = new File(installLocation, "/configuration/exit.ini");
        isCrash = creashFile.exists();
        return creashFile;
    }

    public static boolean checkCrash() {
        if (creashFile != null) {
            return isCrash;
        }
        try {
            CrashUtil.initCrashFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isCrash;
    }
}

