/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.project;

import com.pandora.core.CoreActivator;
import com.pandora.core.log.HBLog;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.project.IProjectProcessor;
import com.pandora.core.project.ProcessorResult;
import com.pandora.core.utils.RegistryUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Plugin;

public class ProjectProcessors {
    private static List<IProjectProcessor> allIProjectProcessors = null;
    private static File tempDir = null;

    private static void initProjectFileProcessors() {
        if (allIProjectProcessors == null) {
            try {
                allIProjectProcessors = RegistryUtils.getEp(IProjectProcessor.class, "com.pandora.core.project.projectProcessor", "processor", "class");
            }
            catch (Exception e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
    }

    public static ProcessorResult processorProject(HMobileProject project, File srcDir, File destDir, boolean delCompileSrcFiles, IProjectProcessor.Profile profile) throws IOException {
        ProjectProcessors.initProjectFileProcessors();
        try {
            for (IProjectProcessor projectProcessor : allIProjectProcessors) {
                if (!projectProcessor.enable(project)) continue;
                ProcessorResult result = projectProcessor.processProject(project, srcDir, srcDir, profile);
                if (delCompileSrcFiles && !result.isEmpty() && !result.compileSrcFiles.isEmpty()) {
                    for (String compileSrcFile : result.compileSrcFiles) {
                        FileUtils.deleteQuietly((File)new File(destDir, compileSrcFile));
                    }
                }
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        return new ProcessorResult();
    }

    public static ProcessorResult processorFileInProject(HMobileProject project, File srcFile, IProjectProcessor.Profile profile) throws IOException {
        ProjectProcessors.initProjectFileProcessors();
        if (allIProjectProcessors.isEmpty()) {
            return new ProcessorResult();
        }
        for (IProjectProcessor projectProcessor : allIProjectProcessors) {
            if (!projectProcessor.enable(project) || srcFile != null && srcFile.exists() && !projectProcessor.enable(project, srcFile.getName())) continue;
            return projectProcessor.processFile(project, project.getProject().getLocation().makeAbsolute().toFile(), ProjectProcessors.getTempDir(), srcFile, profile);
        }
        return new ProcessorResult();
    }

    private static File getTempDir() {
        if (tempDir == null) {
            tempDir = CoreActivator.getDefault().getBundle().getDataFile(".tmp");
            tempDir.mkdirs();
        }
        return tempDir;
    }
}

