/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.project;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.CoreActivator;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.core.project.Messages;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class HMobileProject {
    public static final String MAIN_CONFIG = "manifest.json";
    public static final String NATURE_ID = "com.pandora.projects.ui.MKeyNature";
    public static final String WX_NATURE_ID = "com.pandora.projects.ui.wxNature";
    public static final String WAP2APP_NATURE_ID = "com.pandora.projects.ui.Wap2AppNature";
    public static final String WECHAT_APP_NATURE_ID = "com.pandora.projects.ui.WechatNature";
    public static final String WAP2APP_APPID_PREFIX = "__W2A__";
    public static final String WAP2APP_SERVER_APPEND_CSS = "server_index_append.css";
    public static final String WAP2APP_APPID_APPEND_CSS = ".append.css";
    public static final String HMOBILEPROJECT_INIT_PERMISSION = "HMOBILEPROJECT_INIT_PERMISSION";
    public static final String HMOBILE_CONFIG_FILE = "manifest.json";
    public static final String APP_STREAM_FILE_NAME = "appstream.json";
    @Deprecated
    public static final String SETTING_PATH = "/";
    @Deprecated
    public static final String APP_SOURCE_FOLDER_NAME = "";
    @Deprecated
    public static final String BUILT_IN_IDENTIFIER = "built_in:";
    private String appid = null;
    private IProject project = null;

    protected HMobileProject(IProject project) {
        this.project = project;
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    public String getAppid() {
        if (StringUtil.isBlank((String)this.appid)) {
            this.appid = this.getAppConfig().getAppid();
        }
        return this.appid;
    }

    public void setAppid(String appid) throws CoreException {
        this.appid = appid;
    }

    public boolean isPackageAllow() {
        ArrayList<String> errorMsg = new ArrayList<String>();
        this.verifyAppConfig(errorMsg);
        return errorMsg.isEmpty();
    }

    public static boolean isFilterFile(String fileName) {
        return false;
    }

    public static boolean isFilterFolder(String path) {
        return false;
    }

    private void verifyAppConfig(List<String> errorMsg) {
        IFile ifile = this.project.getFile("manifest.json");
        try {
            Element signatureEl;
            Element contentEl;
            File file = FileUtil.convertIFileToFile((IFile)ifile);
            String content = FileUtils.readFileToString((File)file);
            Document doc = DocumentHelper.parseText((String)content);
            Element root = doc.getRootElement();
            if (root != null) {
                String id;
                String version = root.attributeValue("version");
                if (StringUtil.isEmpty((String)version)) {
                    errorMsg.add(Messages.HMobileProject_VersionNull);
                }
                if (StringUtil.isEmpty((String)(id = root.attributeValue("id")))) {
                    errorMsg.add(Messages.HMobileProject_AppidNull);
                }
            } else {
                errorMsg.add(Messages.HMobileProject_InvalidConfiguration);
                return;
            }
            Element iconEl = root.element("icon");
            if (iconEl != null) {
                String iconSrc = iconEl.attributeValue("src");
                if (StringUtil.isEmpty((String)iconSrc)) {
                    errorMsg.add(Messages.HMobileProject_IconNull);
                }
            } else {
                errorMsg.add(Messages.HMobileProject_NotIcon);
            }
            if ((contentEl = root.element("content")) != null) {
                String indexPage = contentEl.attributeValue("src");
                if (StringUtil.isEmpty((String)indexPage)) {
                    errorMsg.add(Messages.HMobileProject_SrcNull);
                }
            } else {
                errorMsg.add(Messages.HMobileProject_NotContent);
            }
            if ((signatureEl = root.element("signature")) != null) {
                String signInfo = signatureEl.attributeValue("encode");
                StringUtil.isEmpty((String)signInfo);
            } else {
                errorMsg.add(Messages.HMobileProject_SingNull);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public ManifastConfiguration getAppConfigWithError() throws JsonSyntaxException {
        try {
            IFile configFile = this.project.getFile("manifest.json");
            String isInit = this.project.getPersistentProperty(this.getInitPermissionPropertyName());
            if (configFile.exists()) {
                Gson gson = new Gson();
                File file = configFile.getLocation().makeAbsolute().toFile();
                String jsonString = FileUtils.readFileToString((File)file);
                ManifastConfiguration configuration = (ManifastConfiguration)gson.fromJson(jsonString, ManifastConfiguration.class);
                if (configuration == null && StringUtil.isEmpty((String)(configuration = new ManifastConfiguration()).getAppName())) {
                    configuration.setAppName(this.project.getName());
                }
                if (StringUtil.isBlank((String)isInit) || !isInit.equals("true")) {
                    Permission permission = configuration.getPermissions();
                    if (permission == null) {
                        permission = new Permission();
                    }
                    this.project.setPersistentProperty(this.getInitPermissionPropertyName(), "true");
                    configuration.setPermissions(permission);
                }
                return configuration;
            }
        }
        catch (CoreException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        return new ManifastConfiguration();
    }

    public ManifastConfiguration getAppConfig() {
        try {
            return this.getAppConfigWithError();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        return new ManifastConfiguration();
    }

    public String getOutputFolder() {
        return this.project.getLocation().makeAbsolute().toFile().getAbsolutePath();
    }

    private QualifiedName getInitPermissionPropertyName() {
        return new QualifiedName(NATURE_ID, HMOBILEPROJECT_INIT_PERMISSION);
    }

    public IPath getSourceRoot() {
        return this.project.getLocation();
    }
}

