/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.mobile.verification;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.model.Developer;
import com.pandora.core.mobile.model.Distribute;
import com.pandora.core.mobile.model.Icons;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.Plus;
import com.pandora.core.mobile.model.SplashScreen;
import com.pandora.core.mobile.model.Version;
import com.pandora.core.mobile.model.android.AndroidIcon;
import com.pandora.core.mobile.model.android.AndroidSplashScreen;
import com.pandora.core.mobile.model.android.GoogleProfile;
import com.pandora.core.mobile.model.ios.AppleProfile;
import com.pandora.core.mobile.model.ios.IOSIcon;
import com.pandora.core.mobile.model.ios.IOSSplashScreen;
import com.pandora.core.mobile.model.ios.IPadIcon;
import com.pandora.core.mobile.model.ios.IPadSplashScreen;
import com.pandora.core.mobile.model.ios.IPhoneIcon;
import com.pandora.core.mobile.model.ios.IPhoneSplashScreen;
import com.pandora.core.mobile.model.permission.NativeUI;
import com.pandora.core.mobile.model.permission.Navigator;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.core.mobile.model.permission.Webview;
import com.pandora.core.mobile.model.plugins.Baidu;
import com.pandora.core.mobile.model.plugins.IGexinPush;
import com.pandora.core.mobile.model.plugins.Maps;
import com.pandora.core.mobile.model.plugins.MiPush;
import com.pandora.core.mobile.model.plugins.Oauth;
import com.pandora.core.mobile.model.plugins.Payment;
import com.pandora.core.mobile.model.plugins.Plugins;
import com.pandora.core.mobile.model.plugins.Push;
import com.pandora.core.mobile.model.plugins.QQ;
import com.pandora.core.mobile.model.plugins.Share;
import com.pandora.core.mobile.model.plugins.Sina;
import com.pandora.core.mobile.model.plugins.Speech;
import com.pandora.core.mobile.model.plugins.Statics;
import com.pandora.core.mobile.model.plugins.Tencent;
import com.pandora.core.mobile.model.plugins.Weixin;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StringUtil;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;

public class ManifastConfigurationVerification {
    public static final String ICON_SPLASH_CHANGED_MARK = "iconsplashchanged";
    private static final String PLUGIN_ERROR_TEXT = "\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528";
    private static final String MODULE_ERROR_TEXT = "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e";
    private static final String PERMISSION_ERROR_TEXT = " \u6a21\u5757\u67d0\u4e9bAPI\u7f3a\u5c11\u6b64\u6743\u9650\u65e0\u6cd5\u4f7f\u7528";
    private static final Map<String, String> moduleNameMap = new HashMap<String, String>();
    private static final Map<String, Map<String[], List<String>>> modulePermissionMap = new HashMap<String, Map<String[], List<String>>>();
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static Map<String, String> verify(ManifastConfiguration config, IProject project, VerificationPlatform platform) {
        return ManifastConfigurationVerification.verify(config, project, platform, true, false);
    }

    public static Map<String, String> verify(ManifastConfiguration config, IProject project, VerificationPlatform platform, boolean checkPlugin, boolean markIconSplashChanged) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (config != null) {
            Distribute distribute;
            String delay;
            String icon;
            Version version;
            boolean isStream = false;
            if (platform == VerificationPlatform.STREAM) {
                isStream = true;
                platform = VerificationPlatform.ANDROID;
            }
            boolean isWap2App = false;
            try {
                isWap2App = project.hasNature("com.pandora.projects.ui.Wap2AppNature");
            }
            catch (CoreException e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
            if (StringUtil.isBlank((String)config.getAppid())) {
                map.put("manifest.id", null);
            } else if (config.getAppid().length() > 100) {
                map.put("manifest.id", "\u957f\u5ea6\u5fc5\u987b\u5728100\u4e2a\u5b57\u7b26\u5185");
            } else if (!config.getAppid().matches("[0-9a-zA-Z\\-_\\.]+")) {
                map.put("manifest.id", "\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u4e2d\u5212\u7ebf");
            } else if (isWap2App && config.getLaunch_path() != null) {
                try {
                    String host = new URL(config.getLaunch_path()).getHost();
                    String id = "__W2A__" + host;
                    if (!config.isWap2AppDev() && !config.getAppid().equalsIgnoreCase(id)) {
                        map.put("manifest.id", "appid\u5fc5\u987b\u7531 (\"__W2A__\" + wap\u7ad9\u9996\u9875\u57df\u540d)\u7ec4\u6210\uff0c\u5f53\u524d\u5e94\u4e3a" + id);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    map.put("manifest.launch_path", "\u4e0d\u662f\u5408\u6cd5\u7684wap\u7ad9\u9996\u9875\u5730\u5740");
                }
            }
            if (StringUtil.isBlank((String)config.getAppName())) {
                map.put("manifest.name", null);
            }
            if ((version = config.getVersion()) == null || StringUtil.isBlank((String)config.getVersion().getName())) {
                map.put("manifest.version.name", null);
            }
            if (version == null || StringUtil.isNotBlank((String)config.getVersion().getCode()) && !StringUtil.isInt((String)config.getVersion().getCode())) {
                map.put("manifest.version.code", "\u5fc5\u987b\u662f\u6574\u6570");
            }
            if (isStream && StringUtil.isBlank((String)config.getDescription())) {
                map.put("manifest.description", "\u6d41\u5e94\u7528\u7684\u5e94\u7528\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String launchPath = config.getLaunch_path();
            try {
                if (StringUtil.isBlank((String)launchPath) || !launchPath.toLowerCase().startsWith("http://") && !launchPath.toLowerCase().startsWith("https://") && !project.getFile(launchPath).exists()) {
                    map.put("manifest.launch_path", isWap2App ? "\u4e0d\u662f\u5408\u6cd5\u7684wap\u7ad9\u9996\u9875\u5730\u5740" : "\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                map.put("manifest.launch_path", isWap2App ? "\u4e0d\u662f\u5408\u6cd5\u7684wap\u7ad9\u9996\u9875\u5730\u5740" : "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (config.getIcons() != null && StringUtil.isNotBlank((String)(icon = config.getIcons().get_48())) && ManifastConfigurationVerification.getFileExists(project, config.getIcons().get_48()) == null) {
                map.put("manifest.icons.48", "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (config.getDeveloper() == null) {
                config.setDeveloper(new Developer());
            }
            Permission module = config.getPermissions();
            Plus plus = config.getPlus();
            if (plus != null && plus.getSplashscreen() != null && StringUtil.isNotBlank((String)(delay = plus.getSplashscreen().getDelay())) && !StringUtil.isInt((String)delay)) {
                map.put("manifest.plus.splashscreen.delay", "\u5fc5\u987b\u662f\u6574\u6570");
            }
            Distribute distribute2 = distribute = plus != null ? plus.getDistribute() : null;
            if (distribute == null || CollectionsUtil.isEmpty(distribute.getOrientation())) {
                map.put("manifest.plus.distribute.orientation", "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a");
            } else {
                List<String> orientations = distribute.getOrientation();
                int i = 0;
                while (i < orientations.size()) {
                    String orientation = orientations.get(i);
                    if (!(i >= 4 || "portrait-primary".equals(orientation) || "landscape-primary".equals(orientation) || "portrait-secondary".equals(orientation) || "landscape-secondary".equals(orientation))) {
                        map.put("manifest.plus.distribute.orientation", "\u683c\u5f0f\u4e0d\u6b63\u786e");
                        break;
                    }
                    if (i >= 4) {
                        map.put("manifest.plus.distribute.orientation", "\u6570\u76ee\u8d85\u51fa\u4e864\u4e2a\uff0c\u8bf7\u5220\u9664\u591a\u4f59\u7684\u5185\u5bb9");
                        break;
                    }
                    ++i;
                }
            }
            Icons icons = distribute != null ? distribute.getIcons() : null;
            SplashScreen splashScreen = distribute != null ? distribute.getSplashscreen() : null;
            boolean isIPhone = false;
            boolean isIPad = false;
            if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) {
                IOSSplashScreen iOSSplashScreen;
                IOSIcon iOSIcon;
                AppleProfile appleProfile;
                AppleProfile appleProfile2 = appleProfile = distribute != null ? distribute.getApple() : null;
                if (appleProfile == null) {
                    map.put("manifest.plus.distribute.apple", null);
                } else {
                    String devices = appleProfile.getDevices();
                    if (StringUtil.isBlank((String)devices)) {
                        map.put("manifest.plus.distribute.apple.devices", null);
                    } else {
                        isIPhone = "iphone".equals(devices) || "universal".equals(devices);
                        boolean bl = isIPad = "ipad".equals(devices) || "universal".equals(devices);
                        if (!isIPhone && !isIPad) {
                            map.put("manifest.plus.distribute.apple.devices", "\u5fc5\u987b\u662f iphone\u3001ipad \u6216 universal");
                        }
                    }
                }
                IOSIcon iOSIcon2 = iOSIcon = icons != null ? icons.getIos() : null;
                if (iOSIcon != null) {
                    if (!StringUtil.isBoolean((String)iOSIcon.getPrerendered())) {
                        iOSIcon.setPrerendered("false");
                    }
                    if (StringUtil.isEmpty((String)iOSIcon.getAuto())) {
                        ManifastConfigurationVerification.getOldAutoIcon(project, iOSIcon);
                    }
                    if (StringUtil.isNotEmpty((String)iOSIcon.getAuto())) {
                        ManifastConfigurationVerification.checkPNGFile(map, iOSIcon.getAuto(), project, "manifest.plus.distribute.icons.ios.appstore", markIconSplashChanged);
                    }
                    if (isIPhone) {
                        ManifastConfigurationVerification.checkPNGFileOfFileds(map, iOSIcon.getIphone(), "manifest.plus.distribute.icons.ios.iphone.", project, markIconSplashChanged);
                    }
                    if (isIPad) {
                        ManifastConfigurationVerification.checkPNGFileOfFileds(map, iOSIcon.getIpad(), "manifest.plus.distribute.icons.ios.ipad.", project, markIconSplashChanged);
                    }
                }
                IOSSplashScreen iOSSplashScreen2 = iOSSplashScreen = splashScreen != null ? splashScreen.getIos() : null;
                if (iOSSplashScreen != null) {
                    if (isIPhone) {
                        ManifastConfigurationVerification.checkPNGFileOfFileds(map, iOSSplashScreen.getIphone(), "manifest.plus.distribute.splashscreen.ios.iphone.", project, markIconSplashChanged);
                    }
                    if (isIPad) {
                        ManifastConfigurationVerification.checkPNGFileOfFileds(map, iOSSplashScreen.getIpad(), "manifest.plus.distribute.splashscreen.ios.ipad.", project, markIconSplashChanged);
                    }
                }
            }
            if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
                AndroidSplashScreen androidSplashScreen;
                AndroidIcon androidIcon;
                AndroidIcon androidIcon2 = androidIcon = icons != null ? icons.getAndroid() : null;
                if (androidIcon != null) {
                    ManifastConfigurationVerification.checkPNGFileOfFileds(map, androidIcon, "manifest.plus.distribute.icons.android.", project, markIconSplashChanged);
                }
                AndroidSplashScreen androidSplashScreen2 = androidSplashScreen = splashScreen != null ? splashScreen.getAndroid() : null;
                if (androidSplashScreen != null) {
                    ManifastConfigurationVerification.checkPNGFileOfFileds(map, androidSplashScreen, "manifest.plus.distribute.splashscreen.android.", project, markIconSplashChanged);
                }
            }
            if (platform == null) {
                map.put(ICON_SPLASH_CHANGED_MARK, "true");
            }
            if (checkPlugin) {
                Plugins plugins = distribute != null ? distribute.getPlugins() : null;
                boolean isAlpha = ProductUtils.isAlpha();
                HashMap<String, String> weixinAppids = new HashMap<String, String>();
                HashMap<String, String> qqAppids = new HashMap<String, String>();
                HashMap<String, String> sinaAppids = new HashMap<String, String>();
                Maps maps = plugins != null ? plugins.getMap() : null;
                boolean hasModule = module != null && module.getOAuth() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, maps, "manifest.plus.distribute.plugins.maps", "\u5730\u56feSDK", "manifest.permissions.Maps", module != null && module.getMaps() != null, true, false, platform, weixinAppids, qqAppids, sinaAppids);
                Oauth oauth = plugins != null ? plugins.getOauth() : null;
                hasModule = module != null && module.getOAuth() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, oauth, "manifest.plus.distribute.plugins.oauth", "\u767b\u5f55\u9274\u6743", "manifest.permissions.OAuth", hasModule, false, false, platform, weixinAppids, qqAppids, sinaAppids);
                Payment payment = plugins != null ? plugins.getPayment() : null;
                hasModule = module != null && module.getPayment() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, payment, "manifest.plus.distribute.plugins.payment", "\u652f\u4ed8SDK", "manifest.permissions.Payment", hasModule, false, !isAlpha, platform, weixinAppids, qqAppids, sinaAppids);
                Push push = plugins != null ? plugins.getPush() : null;
                hasModule = module != null && module.getPush() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, push, "manifest.plus.distribute.plugins.push", "\u63a8\u9001SDK", "manifest.permissions.Push", hasModule, true, !isAlpha, platform, weixinAppids, qqAppids, sinaAppids);
                Share share = plugins != null ? plugins.getShare() : null;
                hasModule = module != null && module.getShare() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, share, "manifest.plus.distribute.plugins.share", "\u5206\u4eabSDK", "manifest.permissions.Share", hasModule, false, !isAlpha, platform, weixinAppids, qqAppids, sinaAppids);
                Statics statics = plugins != null ? plugins.getStatics() : null;
                hasModule = module != null && module.getStatistic() != null;
                ManifastConfigurationVerification.checkPluginOfFileds(map, statics, "manifest.plus.distribute.plugins.statics", "\u7edf\u8ba1SDK", "manifest.permissions.Statistic", hasModule, false, !isAlpha, platform, weixinAppids, qqAppids, sinaAppids);
                ManifastConfigurationVerification.checkEquals(weixinAppids, "\u5fae\u4fe1\u767b\u5f55\u3001\u5fae\u4fe1\u652f\u4ed8\u3001\u5fae\u4fe1\u6d88\u606f\u53ca\u670b\u53cb\u5708\u7684appid\u5fc5\u987b\u4e00\u81f4", map);
                ManifastConfigurationVerification.checkEquals(qqAppids, "QQ\u767b\u5f55\u3001\u5206\u4eab\u5230QQ\u597d\u53cb\u7684appid\u5fc5\u987b\u4e00\u81f4", map);
                ManifastConfigurationVerification.checkEquals(sinaAppids, "\u65b0\u6d6a\u5fae\u535a\u767b\u5f55\u3001\u65b0\u6d6a\u5fae\u535a\u7684appkey\u5fc5\u987b\u4e00\u81f4", map);
            }
        }
        return map;
    }

    private static void checkEquals(Map<String, String> appidMap, String error, Map<String, String> errorMap) {
        Collection<String> list;
        if (!appidMap.isEmpty() && (list = appidMap.values()) != null && list.size() > 0 && new HashSet<String>(list).size() != 1) {
            for (String key : appidMap.keySet()) {
                errorMap.put(key, error);
            }
        }
    }

    private static void checkPNGFileOfFileds(final Map<String, String> errors, Object parent, String parentNodes, final IProject project, final boolean markIconSplashChanged) {
        ManifastConfigurationVerification.filterFields(parent, parentNodes, new ObjectFiledChecker(){

            @Override
            public void checkFiled(String fieldNodes, Object filedValue) {
                ManifastConfigurationVerification.checkPNGFile(errors, (String)filedValue, project, fieldNodes, markIconSplashChanged);
            }
        });
    }

    private static void checkPNGFile(Map<String, String> errors, String filePath, IProject project, String fieldNodes, boolean markIconSplashChanged) {
        block10: {
            try {
                if (StringUtil.isBlank((String)filePath)) {
                    return;
                }
                File file = ManifastConfigurationVerification.getFileExists(project, filePath);
                if (file == null) {
                    errors.put(fieldNodes, "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    break block10;
                }
                if (file.length() == 0L) {
                    errors.put(fieldNodes, "\u4e0d\u662f\u5408\u6cd5\u7684png\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u7a7a\u767d\u6587\u4ef6");
                    break block10;
                }
                byte[] data = new byte[8];
                FileInputStream input = null;
                try {
                    input = new FileInputStream(file);
                    input.read(data);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                if (!Arrays.equals(data, PNG_SIGNATURE)) {
                    boolean endsWithPNG = file.getName().toLowerCase().endsWith(".png");
                    errors.put(fieldNodes, "\u4e0d\u662f\u5408\u6cd5\u7684png\u6587\u4ef6" + (endsWithPNG ? "\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u540e\u7f00\u540d\u4fee\u6539\u4e3a.png\u7684\u975epng\u6587\u4ef6" : ""));
                } else if (markIconSplashChanged) {
                    errors.put(ICON_SPLASH_CHANGED_MARK, "true");
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
    }

    private static void checkPluginOfFileds(final Map<String, String> errors, Object sdkObject, String sdkNodes, String sdkName, String moduleNodes, boolean hasModule, boolean checkUniqueness, boolean checkMissPlugin, final VerificationPlatform platform, final Map<String, String> weixinAppids, final Map<String, String> qqAppids, final Map<String, String> sinaAppids) {
        final ArrayList pluginsNodes = new ArrayList();
        if (sdkObject != null) {
            ManifastConfigurationVerification.filterFields(sdkObject, sdkNodes, new ObjectFiledChecker(){

                @Override
                public void checkFiled(String pluginNodes, Object pluginObject) {
                    try {
                        if (pluginObject != null && !(pluginObject instanceof String)) {
                            pluginsNodes.add(pluginNodes);
                            ManifastConfigurationVerification.filterFields(pluginObject, pluginNodes, new ObjectFiledChecker(){

                                @Override
                                public void checkFiled(String fieldNodes, Object fieldValue) {
                                    if (fieldNodes.endsWith(".description")) {
                                        return;
                                    }
                                    if (fieldNodes.endsWith("_ios") && platform == VerificationPlatform.ANDROID) {
                                        return;
                                    }
                                    if (fieldNodes.endsWith("_android") && platform == VerificationPlatform.IOS) {
                                        return;
                                    }
                                    if (StringUtil.isBlank((String)((String)fieldValue))) {
                                        errors.put(fieldNodes, null);
                                    } else if (fieldNodes.endsWith(".weixin.appid")) {
                                        weixinAppids.put(fieldNodes, StringUtil.trimToEmpty((String)((String)fieldValue)));
                                    } else if (fieldNodes.endsWith(".qq.appid")) {
                                        qqAppids.put(fieldNodes, StringUtil.trimToEmpty((String)((String)fieldValue)));
                                    } else if (fieldNodes.endsWith(".sina.appkey")) {
                                        sinaAppids.put(fieldNodes, StringUtil.trimToEmpty((String)((String)fieldValue)));
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                    }
                }
            });
        }
        if (!hasModule && !pluginsNodes.isEmpty()) {
            errors.put(moduleNodes, String.valueOf(sdkName) + PLUGIN_ERROR_TEXT);
        }
        if (checkUniqueness && pluginsNodes.size() > 1) {
            for (String pluginNodes : pluginsNodes) {
                errors.put(pluginNodes, "\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u591a\u4e2a" + sdkName);
            }
        }
        if (checkMissPlugin && hasModule && pluginsNodes.isEmpty()) {
            errors.put(moduleNodes, MODULE_ERROR_TEXT + sdkName);
        }
    }

    private static void filterFields(Object parent, String parentNodes, ObjectFiledChecker fieldChecker) {
        Field[] fields;
        if (parent == null) {
            return;
        }
        if (!parentNodes.endsWith(".")) {
            parentNodes = String.valueOf(parentNodes) + '.';
        }
        Field[] fieldArray = fields = parent.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Deprecated.class) && !field.isAnnotationPresent(Transient.class)) {
                String fieldNodes = field.getName();
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    fieldNodes = serializedName.value();
                }
                try {
                    fieldChecker.checkFiled(String.valueOf(parentNodes) + fieldNodes, field.get(parent));
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static Map<String, String> verifyPermission(ManifastConfiguration config, IProject project, VerificationPlatform platform) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
            Field[] fields;
            Permission module = config.getPermissions();
            if (module == null) {
                return map;
            }
            Plus plus = config.getPlus();
            Set<String> nowPermissions = null;
            if (plus != null && plus.getDistribute() != null && plus.getDistribute().getGoogle() != null) {
                nowPermissions = plus.getDistribute().getGoogle().getPermissions();
            }
            Plugins plugins = null;
            if (plus != null && plus.getDistribute() != null) {
                plugins = plus.getDistribute().getPlugins();
            }
            ManifastConfigurationVerification.getModuleAndPermissionsMap(null);
            Field[] fieldArray = fields = module.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName;
                Map<String[], List<String>> permissionMaps;
                Field field = fieldArray[n2];
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null && (permissionMaps = modulePermissionMap.get(moduleName = serializedName.value())) != null && !permissionMaps.isEmpty()) {
                    field.setAccessible(true);
                    try {
                        if (field.get(module) != null) {
                            if (permissionMaps.size() == 1 && permissionMaps.keySet().iterator().next().length == 0) {
                                List<String> requiredPermissionList = permissionMaps.values().iterator().next();
                                for (String permissionStr : requiredPermissionList) {
                                    if (nowPermissions != null && nowPermissions.contains(permissionStr)) continue;
                                    map.put("manifest.plus.distribute.google.permissions." + permissionStr, String.valueOf(moduleNameMap.get(moduleName)) + PERMISSION_ERROR_TEXT);
                                }
                            } else if (permissionMaps.size() >= 1 && plugins != null) {
                                Set<String[]> requiredPluginPaths = permissionMaps.keySet();
                                for (String[] requiredPluginPath : requiredPluginPaths) {
                                    if (ReflectUtils.getFieldValue(plugins, requiredPluginPath) == null) continue;
                                    List<String> permissionList = permissionMaps.get(requiredPluginPath);
                                    for (String permissionStr : permissionList) {
                                        if (nowPermissions != null && nowPermissions.contains(permissionStr)) continue;
                                        map.put("manifest.plus.distribute.google.permissions." + permissionStr, String.valueOf(moduleNameMap.get(moduleName)) + PERMISSION_ERROR_TEXT);
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return map;
    }

    public static Map<String, Map<String[], List<String>>> getModuleAndPermissionsMap(JSONObject jsonConfig) {
        if (modulePermissionMap.isEmpty()) {
            block15: {
                if (jsonConfig == null) {
                    InputStream configFileInput = null;
                    try {
                        try {
                            URL url = Platform.getBundle((String)"com.pandora.editor.ui").getResource("/config/appeditor_permission.json");
                            configFileInput = url.openStream();
                            jsonConfig = new JSONObject(configFileInput);
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                            IOUtils.closeQuietly(configFileInput);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(configFileInput);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)configFileInput);
                }
            }
            if (jsonConfig != null) {
                try {
                    JSONArray listJsonArray = jsonConfig.optJSONObject("modules").optJSONArray("list");
                    int i = 0;
                    while (i < listJsonArray.size()) {
                        JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                        String moduleName = listJsonObject.optString("path");
                        boolean hasSub = listJsonObject.optBoolean("hassub");
                        moduleNameMap.put(moduleName, listJsonObject.optString("desc"));
                        if (listJsonObject.has("permissions")) {
                            JSONArray permissions = listJsonObject.optJSONArray("permissions");
                            HashMap<String[], List<String>> permissionsMap = new HashMap<String[], List<String>>();
                            if (!hasSub) {
                                permissionsMap.put(new String[0], Arrays.asList((String[])permissions.toArray((Object[])new String[permissions.size()])));
                                modulePermissionMap.put(moduleName, permissionsMap);
                            } else {
                                int y = 0;
                                while (y < permissions.size()) {
                                    JSONObject permissionsJsonObject = permissions.getJSONObject(y);
                                    String pluginpath = permissionsJsonObject.optString("pluginpath");
                                    JSONArray subpermissions = permissionsJsonObject.optJSONArray("subpermissions");
                                    permissionsMap.put(pluginpath.split("\\."), Arrays.asList((String[])subpermissions.toArray((Object[])new String[subpermissions.size()])));
                                    ++y;
                                }
                                modulePermissionMap.put(moduleName, permissionsMap);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                }
            }
        }
        return modulePermissionMap;
    }

    public static String getModuleShowName(String moduleName) {
        ManifastConfigurationVerification.getModuleAndPermissionsMap(null);
        return moduleNameMap.get(moduleName);
    }

    public static JsonObject setDefaultValues(ManifastConfiguration config, File configFile, IProject project, VerificationPlatform platform, boolean needAddDebug, boolean needDefaultSplash) throws IOException {
        return ManifastConfigurationVerification.setDefaultValues(config, configFile, project, platform, needAddDebug, needDefaultSplash, false);
    }

    public static JsonObject setDefaultValues(ManifastConfiguration config, File configFile, IProject project, VerificationPlatform platform, boolean needAddDebug, boolean needDefaultSplash, boolean debugMode) throws IOException {
        Plugins plugins;
        Permission permissions;
        JsonElement jsonElement = new JsonParser().parse(FileUtils.readFileToString((File)configFile));
        Gson gson = new Gson();
        JsonObject json = jsonElement.getAsJsonObject();
        if (config.getPermissions() == null) {
            permissions = new Permission();
            json.add("permissions", gson.toJsonTree((Object)permissions));
            config.setPermissions(permissions);
        } else {
            permissions = config.getPermissions();
            if (permissions.getUi() != null) {
                JsonObject permissionsObject = json.getAsJsonObject("permissions");
                if (permissions.getNativeUI() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "NativeUI", new NativeUI());
                }
                if (permissions.getNavigator() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "Navigator", new Navigator());
                }
                if (permissions.getWebview() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "Webview", new Webview());
                }
            }
        }
        File file = null;
        if (config.getIcons() != null) {
            JsonObject iconsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, json, "icons", config.getIcons());
            file = ManifastConfigurationVerification.getFileExists(project, config.getIcons().get_48());
            if (file != null) {
                iconsJson.addProperty("48", file.getAbsolutePath());
                config.getIcons().set_48(file.getAbsolutePath());
                file = null;
            }
        }
        if (config.getDeveloper() != null) {
            JsonObject developerJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, json, "developer", config.getDeveloper());
            if (StringUtil.isBlank((String)config.getDeveloper().getEmail())) {
                developerJson.addProperty("email", UserAuth.getUsername());
                config.getDeveloper().setEmail(UserAuth.getUsername());
            }
            if (StringUtil.isBlank((String)config.getDeveloper().getName())) {
                developerJson.addProperty("name", UserAuth.getUsername());
                config.getDeveloper().setName(UserAuth.getUsername());
            }
        }
        Plus plus = config.getPlus();
        JsonObject plusJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, json, "plus", plus);
        if (plus.getAds() != null && !plus.getAds().isEmpty()) {
            plusJson.add("ads", gson.toJsonTree(plus.getAds()));
        }
        try {
            if (project.hasNature("com.pandora.projects.ui.Wap2AppNature")) {
                Map<String, Object> secondwebview = plus.getSecondwebview() != null ? plus.getSecondwebview() : new HashMap<String, Object>();
                if (secondwebview.get("mode") == null || StringUtil.isBlank((String)secondwebview.get("mode").toString())) {
                    secondwebview.put("mode", "behind");
                }
                secondwebview.put("launch_path", "_www/client_index.html");
                secondwebview.put("id", "__W2A_CONTEXT_");
                plusJson.add("secondwebview", gson.toJsonTree(secondwebview));
                plus.setSecondwebview(secondwebview);
                ManifastConfigurationVerification.mergeLaunchWebView(project, plusJson, config.getAppid());
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        if (StringUtil.isNotBlank((String)plus.getRamcachemode())) {
            plusJson.addProperty("ramcachemode", plus.getRamcachemode());
        }
        if (plus.getSplashscreen() != null) {
            JsonObject splashscreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, plusJson, "splashscreen", plus.getSplashscreen());
            boolean autoclose = plus.getSplashscreen().getAutoclose();
            splashscreenJson.addProperty("autoclose", Boolean.valueOf(autoclose));
        }
        JsonObject distributeJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, plusJson, "distribute", plus.getDistribute());
        if (plus.getDistribute().isDebug() || needAddDebug) {
            distributeJson.addProperty("debug", Boolean.valueOf(plus.getDistribute().isDebug()));
        }
        if (debugMode) {
            distributeJson.remove("debug");
            distributeJson.addProperty("debug", Boolean.valueOf(true));
            distributeJson.addProperty("syncDebug", Boolean.valueOf(true));
            JsonObject permissionsObject = json.getAsJsonObject("permissions");
            if (permissionsObject != null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("description", "\u8c03\u8bd5\u8f93\u51fa\u65e5\u5fd7");
                permissionsObject.add("Console", (JsonElement)jsonObject);
            }
        }
        if (!distributeJson.has("orientation")) {
            plus.getDistribute().getOrientation().clear();
            plus.getDistribute().getOrientation().add("portrait-primary");
            distributeJson.add("orientation", gson.toJsonTree(plus.getDistribute().getOrientation()));
        }
        Icons icons = plus.getDistribute().getIcons();
        JsonObject iconsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "icons", icons);
        SplashScreen splashScreen = plus.getDistribute().getSplashscreen();
        boolean isIPhone = false;
        boolean isIPad = false;
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) {
            String devices;
            AppleProfile appleProfile = plus.getDistribute().getApple();
            JsonObject appleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "apple", plus.getDistribute().getApple());
            appleProfileJson.addProperty("appid", appleProfile.getAppid());
            appleProfileJson.addProperty("password", appleProfile.getPassword());
            appleProfileJson.addProperty("mobileprovision", appleProfile.getMobileprovision());
            appleProfileJson.addProperty("p12", appleProfile.getP12());
            if (debugMode) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("Add :UIFileSharingEnabled bool true");
                appleProfileJson.add("plistcmds", gson.toJsonTree(list));
            }
            isIPhone = "iphone".equals(devices = appleProfile.getDevices()) || "universal".equals(devices);
            isIPad = "ipad".equals(devices) || "universal".equals(devices);
            appleProfileJson.addProperty("devices", devices);
            if (icons != null) {
                IOSIcon iOSIcon = icons.getIos();
                JsonObject iOSIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iconsJson, "ios", iOSIcon);
                if (!StringUtil.isBoolean((String)iOSIcon.getPrerendered())) {
                    iOSIcon.setPrerendered("false");
                }
                iOSIconJson.addProperty("prerendered", iOSIcon.getPrerendered());
                String appstore = iOSIcon.getAuto();
                StringUtil.isEmpty((String)appstore);
                iOSIconJson.addProperty("appstore", iOSIcon.getAuto());
                iOSIconJson.remove("auto");
                if (isIPhone) {
                    IPhoneIcon iPhoneIcon = iOSIcon.getIphone();
                    iOSIconJson.add("iphone", gson.toJsonTree((Object)iPhoneIcon));
                }
                if (isIPad) {
                    IPadIcon iPadIcon = iOSIcon.getIpad();
                    iOSIconJson.add("ipad", gson.toJsonTree((Object)iPadIcon));
                }
            }
            if (splashScreen != null) {
                JsonObject splashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "splashscreen", splashScreen);
                IOSSplashScreen iOSSplashScreen = splashScreen.getIos();
                JsonObject iOSSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, splashScreenJson, "ios", iOSSplashScreen);
                if (isIPhone) {
                    IPhoneSplashScreen iPhoneSplashScreen = iOSSplashScreen.getIphone();
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSSplashScreenJson, "iphone", iPhoneSplashScreen);
                }
                if (isIPad) {
                    IPadSplashScreen iPadSplashScreen = iOSSplashScreen.getIpad();
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSSplashScreenJson, "ipad", iPadSplashScreen);
                }
            }
        }
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
            JsonObject googleProfileJson;
            GoogleProfile googleProfile = config.getPlus().getDistribute().getGoogle();
            if (googleProfile != null) {
                googleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "google", googleProfile);
                googleProfileJson.addProperty("packagename", googleProfile.getPackagename());
                googleProfileJson.addProperty("password", googleProfile.getPassword());
                googleProfileJson.addProperty("aliasname", googleProfile.getAliasname());
                googleProfileJson.addProperty("keystore", googleProfile.getKeystore());
                googleProfileJson.addProperty("custompermissions", Boolean.valueOf(true));
            } else {
                googleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "google", new GoogleProfile());
                googleProfileJson.addProperty("custompermissions", Boolean.valueOf(true));
            }
            if (icons != null) {
                AndroidIcon androidIcon = icons.getAndroid();
                JsonObject androidIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iconsJson, "android", androidIcon);
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getMdpi());
                if (file != null) {
                    androidIconJson.addProperty("mdpi", file.getAbsolutePath());
                    androidIcon.setMdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("mdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                    androidIcon.setMdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getLdpi());
                if (file != null) {
                    androidIconJson.addProperty("ldpi", file.getAbsolutePath());
                    androidIcon.setLdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("ldpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                    androidIcon.setLdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getHdpi());
                if (file != null) {
                    androidIconJson.addProperty("hdpi", file.getAbsolutePath());
                    androidIcon.setHdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("hdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon72.png"));
                    androidIcon.setHdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon72.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getXhdpi());
                if (file != null) {
                    androidIconJson.addProperty("xhdpi", file.getAbsolutePath());
                    androidIcon.setXhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("xhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon96.png"));
                    androidIcon.setXhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon96.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getXxhdpi());
                if (file != null) {
                    androidIconJson.addProperty("xxhdpi", file.getAbsolutePath());
                    androidIcon.setXxhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("xxhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon144.png"));
                    androidIcon.setXxhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon144.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getXxxhdpi());
                if (file != null) {
                    androidIconJson.addProperty("xxxhdpi", file.getAbsolutePath());
                    androidIcon.setXxxhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("xxxhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon192.png"));
                    androidIcon.setXxxhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon192.png"));
                }
            }
            if (splashScreen != null) {
                JsonObject splashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "splashscreen", splashScreen);
                AndroidSplashScreen androidSplashScreen = splashScreen.getAndroid();
                JsonObject androidSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, splashScreenJson, "android", androidSplashScreen);
                androidSplashScreen.setMdpi(null);
                androidSplashScreenJson.remove("mdpi");
                androidSplashScreen.setLdpi(null);
                androidSplashScreenJson.remove("ldpi");
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getHdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("hdpi", file.getAbsolutePath());
                    androidSplashScreen.setHdpi(file.getAbsolutePath());
                    file = null;
                } else if (needDefaultSplash) {
                    androidSplashScreenJson.addProperty("hdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash480x762.png"));
                    androidSplashScreen.setHdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash480x762.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXhdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("xhdpi", file.getAbsolutePath());
                    androidSplashScreen.setXhdpi(file.getAbsolutePath());
                    file = null;
                } else if (needDefaultSplash) {
                    androidSplashScreenJson.addProperty("xhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash720x1242.png"));
                    androidSplashScreen.setXhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash720x1242.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXxhdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("xxhdpi", file.getAbsolutePath());
                    androidSplashScreen.setXxhdpi(file.getAbsolutePath());
                    file = null;
                } else if (needDefaultSplash) {
                    androidSplashScreenJson.addProperty("xxhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash1080x1882.png"));
                    androidSplashScreen.setXxhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash1080x1882.png"));
                }
            }
        }
        if ((plugins = plus.getDistribute().getPlugins()) != null) {
            Maps map;
            Push push;
            Share share;
            Speech speech;
            JsonObject pluginsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "plugins", plugins);
            Statics statics = plugins.getStatics();
            if (statics != null) {
                JsonObject staticsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "statics", statics);
                if (StringUtil.isBlank((String)statics.getDescription())) {
                    statics.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                staticsJson.addProperty("description", statics.getDescription());
                if (statics.getUmeng() == null) {
                    pluginsJson.remove("statics");
                    plugins.setStatics(null);
                }
            }
            if ((speech = plugins.getSpeech()) != null && (speech.getIfly() == null || StringUtil.isBlank((String)speech.getIfly().getAppid()))) {
                pluginsJson.remove("speech");
                plugins.setSpeech(null);
            }
            if ((share = plugins.getShare()) != null) {
                Sina sina = share.getSina();
                Tencent tencent = share.getTencent();
                Weixin weixin = share.getWeixin();
                QQ qq = share.getQq();
                if (sina == null && tencent == null && weixin == null && qq == null) {
                    pluginsJson.remove("share");
                    plugins.setShare(null);
                } else {
                    JsonObject shareJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "share", share);
                    if (sina != null && (StringUtil.isBlank((String)sina.getAppkey()) || StringUtil.isBlank((String)sina.getAppsecret()) || StringUtil.isBlank((String)sina.getRedirect_uri()))) {
                        shareJson.remove("sina");
                        share.setSina(null);
                    }
                    if (tencent != null && (StringUtil.isBlank((String)tencent.getAppkey()) || StringUtil.isBlank((String)tencent.getAppsecret()) || StringUtil.isBlank((String)tencent.getRedirect_uri()))) {
                        shareJson.remove("tencent");
                        share.setTencent(null);
                    }
                    if (weixin != null && (StringUtil.isBlank((String)weixin.getAppkey()) || StringUtil.isBlank((String)weixin.getAppsecret()))) {
                        shareJson.remove("weixin");
                        share.setWeixin(null);
                    }
                    if (qq != null && StringUtil.isBlank((String)qq.getAppid())) {
                        shareJson.remove("qq");
                        share.setQq(null);
                    }
                }
            }
            if ((push = plugins.getPush()) != null) {
                JsonObject pushJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "push", push);
                if (!StringUtil.isBoolean((String)push.getCover())) {
                    pushJson.addProperty("cover", "false");
                    push.setCover("false");
                }
                if (StringUtil.isBlank((String)push.getDescription())) {
                    push.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                pushJson.addProperty("description", push.getDescription());
                IGexinPush iGexinPush = push.getIgexin();
                MiPush miPush = push.getMipush();
                if (iGexinPush == null && miPush == null) {
                    pluginsJson.remove("push");
                    plugins.setPush(null);
                }
            }
            if ((map = plugins.getMap()) != null) {
                JsonObject mapJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "map", map);
                if (StringUtil.isBlank((String)map.getDescription())) {
                    map.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                mapJson.addProperty("description", push.getDescription());
                Baidu baidumap = map.getBaidumap();
                if (baidumap == null) {
                    pluginsJson.remove("map");
                    plugins.setMap(null);
                }
            }
        }
        return json;
    }

    private static void getOldAutoIcon(IProject project, IOSIcon iOSIcon) {
        try {
            String autoIconPathStr = project.getPersistentProperty(new QualifiedName("com.pandora.editor.ui", "AUTO_ICON_PATH_"));
            if (StringUtil.isNotEmpty((String)autoIconPathStr)) {
                iOSIcon.setAuto(autoIconPathStr);
            }
        }
        catch (CoreException ex) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)ex);
        }
    }

    public static void mergeLaunchWebView(IProject project, JsonObject plusJson, String appid) {
        try {
            String titleNviewKey;
            JsonElement titleNViewElement;
            JsonArray pagesArray;
            IFile sitemapFile = project.getFile("sitemap.json");
            if (sitemapFile == null || !sitemapFile.exists()) {
                return;
            }
            JsonElement sitemapJsonElement = new JsonParser().parse(IOUtil.read((InputStream)sitemapFile.getContents(), (String)sitemapFile.getCharset()));
            if (sitemapJsonElement == null) {
                return;
            }
            JsonObject sitemapJson = sitemapJsonElement.getAsJsonObject();
            if (sitemapJson == null) {
                return;
            }
            JsonObject globalObject = sitemapJson.getAsJsonObject("global");
            JsonElement globalWebviewParameterElement = null;
            String webviewParameterKey = "webviewParameter";
            if (globalObject != null) {
                globalWebviewParameterElement = globalObject.get(webviewParameterKey);
            }
            JsonObject globalWebviewParameterObject = null;
            if (globalWebviewParameterElement != null) {
                globalWebviewParameterObject = globalWebviewParameterElement.getAsJsonObject();
            }
            if (globalWebviewParameterObject != null) {
                ManifastConfigurationVerification.mergeStyle(plusJson, globalWebviewParameterObject);
            }
            if ((pagesArray = sitemapJson.getAsJsonArray("pages")) == null) {
                return;
            }
            JsonObject pageObject = null;
            int i = 0;
            while (i < pagesArray.size()) {
                String webviewId;
                JsonObject currentPageObject;
                JsonElement webviewIdElement;
                JsonElement pageElement = pagesArray.get(i);
                if (pageElement != null && (webviewIdElement = (currentPageObject = pageElement.getAsJsonObject()).get("webviewId")) != null && StringUtil.isNotBlank((String)(webviewId = webviewIdElement.getAsString())) && webviewId.equals(appid)) {
                    pageObject = currentPageObject;
                    break;
                }
                ++i;
            }
            if (pageObject == null) {
                return;
            }
            String launchwebviewKey = "launchwebview";
            JsonElement launchwebviewElement = plusJson.get(launchwebviewKey);
            JsonObject launchwebviewObject = null;
            launchwebviewObject = launchwebviewElement == null ? new JsonObject() : launchwebviewElement.getAsJsonObject();
            JsonElement webviewParameterElement = pageObject.get(webviewParameterKey);
            JsonObject webviewParameterObject = null;
            if (webviewParameterElement != null) {
                webviewParameterObject = webviewParameterElement.getAsJsonObject();
            }
            if (webviewParameterObject == null) {
                return;
            }
            boolean added = false;
            if (ManifastConfigurationVerification.mergeTabBar(webviewParameterObject, launchwebviewObject)) {
                JsonObject secondwebview;
                plusJson.add(launchwebviewKey, (JsonElement)launchwebviewObject);
                String secondwebviewKey = "secondwebview";
                JsonElement secondwebviewElement = plusJson.get(secondwebviewKey);
                if (secondwebviewElement == null) {
                    secondwebview = new JsonObject();
                    plusJson.add(secondwebviewKey, (JsonElement)secondwebview);
                } else {
                    secondwebview = secondwebviewElement.getAsJsonObject();
                }
                secondwebview.remove("mode");
                secondwebview.addProperty("mode", "parent");
                added = true;
            }
            if (ManifastConfigurationVerification.mergeStatusbar(webviewParameterObject, launchwebviewObject) && !added) {
                plusJson.add(launchwebviewKey, (JsonElement)launchwebviewObject);
                added = true;
            }
            if ((titleNViewElement = webviewParameterObject.get(titleNviewKey = "titleNView")) == null) {
                return;
            }
            if (!added) {
                plusJson.add(launchwebviewKey, (JsonElement)launchwebviewObject);
            }
            if (globalObject == null) {
                launchwebviewObject.remove(titleNviewKey);
                if (titleNViewElement.isJsonObject()) {
                    launchwebviewObject.add(titleNviewKey, titleNViewElement);
                }
                return;
            }
            if (globalWebviewParameterElement == null) {
                launchwebviewObject.remove(titleNviewKey);
                if (titleNViewElement.isJsonObject()) {
                    launchwebviewObject.add(titleNviewKey, titleNViewElement);
                }
                return;
            }
            JsonElement globalTitleNViewElement = globalWebviewParameterObject.get(titleNviewKey);
            if (globalTitleNViewElement == null) {
                launchwebviewObject.remove(titleNviewKey);
                if (titleNViewElement.isJsonObject()) {
                    launchwebviewObject.add(titleNviewKey, titleNViewElement);
                }
                return;
            }
            ManifastConfigurationVerification.mergeTitleNviewObject(titleNViewElement, globalTitleNViewElement);
            launchwebviewObject.remove(titleNviewKey);
            if (titleNViewElement.isJsonObject()) {
                launchwebviewObject.add(titleNviewKey, titleNViewElement);
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    private static boolean mergeTabBar(JsonObject webviewParameterObject, JsonObject launchwebviewObject) {
        String tabBarPosition;
        int height;
        JsonObject tabBarObject;
        block15: {
            block14: {
                String heightStr;
                block13: {
                    JsonElement tabBarHeightElement;
                    block12: {
                        JsonElement tabBarElement;
                        block11: {
                            try {
                                String tabBarKey = "tabBar";
                                tabBarElement = webviewParameterObject.get(tabBarKey);
                                if (tabBarElement != null) break block11;
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                        tabBarObject = tabBarElement.getAsJsonObject();
                        tabBarHeightElement = tabBarObject.get("height");
                        if (tabBarHeightElement != null) break block12;
                        return false;
                    }
                    heightStr = tabBarHeightElement.getAsString();
                    if (!StringUtil.isBlank((String)heightStr)) break block13;
                    return false;
                }
                heightStr = heightStr.replace("px", "");
                height = Integer.valueOf(heightStr);
                if (height > 0) break block14;
                return false;
            }
            if (webviewParameterObject == null) break block15;
            JsonElement webviewParameterTopElement = webviewParameterObject.get("top");
            JsonElement webviewParameterBottomElement = webviewParameterObject.get("bottom");
            String webviewParameterTopString = "";
            String webviewParameterBottomStrng = "";
            if (webviewParameterTopElement != null) {
                webviewParameterTopString = webviewParameterTopElement.getAsString();
            }
            if (webviewParameterBottomElement != null) {
                webviewParameterBottomStrng = webviewParameterBottomElement.getAsString();
            }
            if (!StringUtil.isNotBlank((String)webviewParameterTopString) || !StringUtil.isNotBlank((String)webviewParameterBottomStrng)) break block15;
            return false;
        }
        int top = 0;
        int bottom = 0;
        boolean isSet = false;
        JsonElement tabBarPositionElememt = tabBarObject.get("position");
        if (tabBarPositionElememt != null && StringUtil.isNotBlank((String)(tabBarPosition = tabBarPositionElememt.getAsString())) && tabBarPosition.equals("top")) {
            isSet = true;
            top = height;
        }
        if (!isSet) {
            bottom = height;
        }
        launchwebviewObject.remove("top");
        launchwebviewObject.remove("bottom");
        launchwebviewObject.addProperty("top", String.valueOf(top) + "px");
        launchwebviewObject.addProperty("bottom", String.valueOf(bottom) + "px");
        return true;
    }

    public static void mergeStyle(JsonObject plusJson, JsonObject globalWebviewParameterObject) {
        String styleKey;
        if (globalWebviewParameterObject == null) {
            return;
        }
        String statusbarKey = "statusbar";
        JsonElement statusbarElement = globalWebviewParameterObject.get(statusbarKey);
        if (statusbarElement == null) {
            return;
        }
        JsonObject statusbarObject = statusbarElement.getAsJsonObject();
        JsonElement styleElement = statusbarObject.get(styleKey = "style");
        if (styleElement == null) {
            return;
        }
        JsonElement plusStatusbarElement = plusJson.get(statusbarKey);
        JsonObject plusStatusbarObject = null;
        if (plusStatusbarElement == null) {
            plusStatusbarObject = new JsonObject();
            plusJson.add(statusbarKey, (JsonElement)plusStatusbarObject);
        } else {
            plusStatusbarObject = plusStatusbarElement.getAsJsonObject();
        }
        plusStatusbarObject.remove(styleKey);
        plusStatusbarObject.add(styleKey, styleElement);
    }

    public static boolean mergeStatusbar(JsonObject webviewParameterObject, JsonObject launchwebviewObject) {
        String statusbarKey = "statusbar";
        JsonElement statusbarElement = webviewParameterObject.get(statusbarKey);
        if (statusbarElement != null) {
            launchwebviewObject.remove(statusbarKey);
            if (statusbarElement.isJsonObject()) {
                launchwebviewObject.add(statusbarKey, statusbarElement);
            }
            return true;
        }
        return false;
    }

    public static void mergeTitleNviewObject(JsonElement pagesElement, JsonElement globalElement) {
        try {
            if (pagesElement.isJsonObject()) {
                JsonObject titleNViewObject = pagesElement.getAsJsonObject();
                JsonObject globalTitleNViewObject = globalElement.getAsJsonObject();
                Set set = globalTitleNViewObject.entrySet();
                for (Map.Entry entry : set) {
                    if (entry == null) continue;
                    String key = (String)entry.getKey();
                    JsonElement entryElement = (JsonElement)entry.getValue();
                    if (entryElement == null) continue;
                    if (!titleNViewObject.has(key)) {
                        titleNViewObject.add(key, entryElement);
                        continue;
                    }
                    JsonElement keyElement = titleNViewObject.get(key);
                    if (!keyElement.isJsonObject()) continue;
                    ManifastConfigurationVerification.mergeTitleNviewObject(keyElement, entryElement);
                }
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    private static JsonObject addDefaultObjectToParent(Gson gson, JsonObject parent, String name, Object object) {
        if (!parent.has(name)) {
            parent.add(name, gson.toJsonTree(object));
        }
        return parent.getAsJsonObject(name);
    }

    private static String getDefaultFilePath(String name) {
        return ResourceUtil.resourcePathToString((URL)Platform.getBundle((String)"com.pandora.editor.ui").getEntry(name));
    }

    public static File getFileExists(IProject project, String pathStr) {
        File file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)project, (String)pathStr);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    private static interface ObjectFiledChecker {
        public void checkFiled(String var1, Object var2);
    }

    public static enum VerificationPlatform {
        IOS,
        ANDROID,
        STREAM,
        ALL;

    }
}

