/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.jslib;

import com.pandora.core.CoreActivator;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class JSLib {
    public static final String JSLIB_ID = "com.pandora.jslib.core";
    public static final String EXT_API = "_builtIn";
    private static String clientRuntimeFrameworkPath = null;

    public static void registeJSLib() {
        Bundle bundle = Platform.getBundle((String)JSLIB_ID);
        String basePath = bundle.getLocation().substring("reference:".length());
        URL url = null;
        try {
            url = new URL(basePath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        basePath = url.getPath();
        if (Platform.getOS().startsWith("win") && basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        clientRuntimeFrameworkPath = String.valueOf(basePath) + "jslib/";
        String installPath = Platform.getInstallLocation().getURL().getPath();
        if (Platform.getOS().startsWith("win") && installPath.startsWith("/")) {
            installPath = installPath.substring(1);
        }
        if (!Platform.inDevelopmentMode()) {
            clientRuntimeFrameworkPath = String.valueOf(installPath) + clientRuntimeFrameworkPath;
        }
        HBLog.logInfo((Plugin)CoreActivator.getDefault(), (String)("ClientRuntimeFrameworkPath:" + clientRuntimeFrameworkPath));
    }

    public static String getJSLibAbsoluteLocation(String relativeLocation) {
        return String.valueOf(clientRuntimeFrameworkPath) + relativeLocation;
    }

    public static String getJSLibLocation() {
        if (StringUtil.isEmpty((String)clientRuntimeFrameworkPath)) {
            JSLib.registeJSLib();
        }
        return clientRuntimeFrameworkPath;
    }
}

