/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.auth;

import com.pandora.core.CoreActivator;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.PlatformUtil;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class UserAuth {
    private static String username = "";
    private static String password = "";
    private static String token = "";
    private static String nickname = "";
    private static String vip_level_name = "";
    private static String vip_expired_at = "";
    private static int vip_level = 0;
    private static int vip_count = 0;
    public static final int USER_LOGIN_ING = -1;
    public static final int USER_LOGIN_SUCESS = 1;
    public static final int USER_LOGIN_FAIL = 0;
    public static final int USER_LOGIN_OFFLINE = -2;
    private static int hasLoginSucess = -1;
    private static boolean hasSign = false;
    private static boolean hasStatisticsOnlineTime = false;

    public static String getNickname() {
        return nickname;
    }

    public static void setNickname(String nickname) {
        UserAuth.nickname = nickname;
    }

    public static String getVip_level_name() {
        return vip_level_name;
    }

    public static void setVip_level_name(String vip_level_name) {
        UserAuth.vip_level_name = vip_level_name;
    }

    public static String getVip_expired_at() {
        return vip_expired_at;
    }

    public static void setVip_expired_at(String vip_expired_at) {
        UserAuth.vip_expired_at = vip_expired_at;
    }

    public static int getVip_count() {
        return vip_count;
    }

    public static void setVip_count(int vip_count) {
        UserAuth.vip_count = vip_count;
    }

    public static int getVip_level() {
        return vip_level;
    }

    public static void setVip_level(int vip_level) {
        UserAuth.vip_level = vip_level;
    }

    public static int isLoginSucess() {
        return hasLoginSucess;
    }

    public static void setHasLoginSucess(int hasLoginSucess) {
        UserAuth.hasLoginSucess = hasLoginSucess;
        UserAuth.signIn();
    }

    private static void signIn() {
        if (hasLoginSucess == 1 && !hasSign) {
            try {
                final IEclipsePreferences node = EclipseUtil.instanceScope().getNode("com.pandora.core");
                long lastSignInTime = node.getLong("LAST_SIGN_IN_TIME", 0L);
                int days = Math.abs(Days.daysBetween((ReadableInstant)new DateTime(lastSignInTime).withTimeAtStartOfDay(), (ReadableInstant)DateTime.now().withTimeAtStartOfDay()).getDays());
                if (days > 0) {
                    Job job = new Job("\u7b7e\u5230Job"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                hasSign = HttpClientUtils.getInstance(null).postIntegralData(3);
                                if (hasSign) {
                                    node.putLong("LAST_SIGN_IN_TIME", System.currentTimeMillis());
                                    node.flush();
                                }
                            }
                            catch (Throwable e) {
                                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                } else {
                    hasSign = true;
                }
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
    }

    public static void statisticsOnlineTime(long startDelay, long circle) {
        try {
            if (!hasStatisticsOnlineTime) {
                final IEclipsePreferences node = EclipseUtil.instanceScope().getNode("com.pandora.core");
                long onlineTime = node.getLong("ONLINE_TIME", 0L);
                long lastTime = node.getLong("LAST_TIME_OF_STATISTICAL", 0L);
                int days = Math.abs(Days.daysBetween((ReadableInstant)new DateTime(lastTime).withTimeAtStartOfDay(), (ReadableInstant)DateTime.now().withTimeAtStartOfDay()).getDays());
                if (days >= 1) {
                    lastTime = System.currentTimeMillis();
                    onlineTime = 0L;
                    node.putLong("LAST_TIME_OF_STATISTICAL", lastTime);
                    node.putLong("ONLINE_TIME", onlineTime);
                    node.flush();
                }
                if (onlineTime >= 0L) {
                    if (onlineTime < 14400000L) {
                        node.putLong("ONLINE_TIME", onlineTime += onlineTime == 0L ? startDelay : circle);
                        node.flush();
                    }
                } else {
                    hasStatisticsOnlineTime = true;
                }
                if (!hasStatisticsOnlineTime && onlineTime >= 14400000L) {
                    Job job = new Job("\u5728\u7ebf\u79ef\u5206"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                hasStatisticsOnlineTime = HttpClientUtils.getInstance(null).postIntegralData(2);
                                if (hasStatisticsOnlineTime) {
                                    node.putLong("ONLINE_TIME", -1L);
                                    node.flush();
                                }
                            }
                            catch (Throwable e) {
                                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    public static void setToken(String newToken) {
        token = newToken;
    }

    public static String getToken() {
        return token;
    }

    public static String getUsername() {
        return username;
    }

    public static String getPassword() {
        return password;
    }

    public static void initUserAuth(String username, String password) {
        UserAuth.username = username;
        UserAuth.password = password;
    }

    public static void destroyUserAuth() {
        File saveFile;
        File hbuilderUserDir;
        username = "";
        password = "";
        hasLoginSucess = 0;
        String tmppath = "";
        tmppath = PlatformUtil.isWindows() ? System.getenv().get("APPDATA") : System.getenv().get("HOME");
        File hbuilderDir = new File(String.valueOf(tmppath) + "/HBuilder");
        if (!hbuilderDir.exists()) {
            hbuilderDir.mkdir();
        }
        if (!(hbuilderUserDir = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User")).exists()) {
            hbuilderUserDir.mkdir();
        }
        if ((saveFile = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User/Save.config")).exists()) {
            saveFile.delete();
        }
    }
}

