/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core;

import com.pandora.core.utils.StringUtil;

public enum JavaScriptVersion {
    ECMASCRIPT5_1("ECMAScript 5.1", 0),
    ECMASCRIPT6("ECMAScript 6", 1);

    private String fName;
    private int fIndex;

    private JavaScriptVersion(String name, int index) {
        this.fName = name;
        this.fIndex = index;
    }

    public String toString() {
        return this.fName;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public static JavaScriptVersion nameOf(String name) {
        if (StringUtil.isNotEmpty((String)name)) {
            JavaScriptVersion[] javaScriptVersionArray = JavaScriptVersion.values();
            int n = javaScriptVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                JavaScriptVersion ver = javaScriptVersionArray[n2];
                if (name.equals(ver.toString())) {
                    return ver;
                }
                ++n2;
            }
        }
        return ECMASCRIPT5_1;
    }

    public static JavaScriptVersion indexOf(int index) {
        JavaScriptVersion[] javaScriptVersionArray = JavaScriptVersion.values();
        int n = javaScriptVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaScriptVersion ver = javaScriptVersionArray[n2];
            if (ver.getIndex() == index) {
                return ver;
            }
            ++n2;
        }
        return ECMASCRIPT5_1;
    }
}

