/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.core.util.ArrayUtil;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.SnippetNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class SnippetsNode
extends BaseNode<Property> {
    private static final Image SNIPPETS_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private SnippetNode[] snippets;

    SnippetsNode(BundleElement bundle) {
        this(bundle.getCommands());
    }

    SnippetsNode(List<CommandElement> elements) {
        LinkedList<SnippetNode> items = new LinkedList<SnippetNode>();
        if (elements != null) {
            Collections.sort(elements);
            for (CommandElement command : elements) {
                if (!(command instanceof SnippetElement)) continue;
                items.add(new SnippetNode((SnippetElement)command));
            }
        }
        this.snippets = items.toArray(new SnippetNode[items.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.snippets;
    }

    @Override
    public Image getImage() {
        return SNIPPETS_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.SnippetsNode_Snippets_Node;
    }

    @Override
    public boolean hasChildren() {
        return !ArrayUtil.isEmpty((Object[])this.snippets);
    }

    static enum Property implements IPropertyInformation<SnippetsNode>
    {
        COUNT(Messages.SnippetsNode_Snippets_Count){

            @Override
            public Object getPropertyValue(SnippetsNode node) {
                return node.snippets.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

