/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.core.util.ArrayUtil;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.SnippetCategoryNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class SnippetCategoriesNode
extends BaseNode<Property> {
    private static final Image SNIPPET_CATEGORIES_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private SnippetCategoryNode[] snippetCategories;

    SnippetCategoriesNode(BundleElement bundle) {
        this(bundle.getSnippetCategories());
    }

    SnippetCategoriesNode(List<SnippetCategoryElement> elements) {
        ArrayList<SnippetCategoryNode> items = new ArrayList<SnippetCategoryNode>();
        if (elements != null) {
            Collections.sort(elements);
            for (SnippetCategoryElement element : elements) {
                if (!(element instanceof SnippetCategoryElement)) continue;
                items.add(new SnippetCategoryNode(element));
            }
        }
        this.snippetCategories = items.toArray(new SnippetCategoryNode[items.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.snippetCategories;
    }

    @Override
    public Image getImage() {
        return SNIPPET_CATEGORIES_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.SnippetCategoriesNode_SnippetCategories_Node;
    }

    @Override
    public boolean hasChildren() {
        return !ArrayUtil.isEmpty((Object[])this.snippetCategories);
    }

    static enum Property implements IPropertyInformation<SnippetCategoriesNode>
    {
        COUNT(Messages.SnippetsNode_Snippets_Count){

            @Override
            public Object getPropertyValue(SnippetCategoriesNode node) {
                return node.snippetCategories.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

