/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.ProjectSampleNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class ProjectSamplesNode
extends BaseNode<Property> {
    private static final Image PROJECT_SAMPLES_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private ProjectSampleNode[] projectSamples;

    ProjectSamplesNode(BundleElement bundle) {
        this(bundle.getProjectSamples());
    }

    ProjectSamplesNode(List<ProjectSampleElement> elements) {
        ArrayList<ProjectSampleNode> samples = new ArrayList<ProjectSampleNode>();
        if (elements != null) {
            for (ProjectSampleElement sample : elements) {
                samples.add(new ProjectSampleNode(sample));
            }
        }
        this.projectSamples = samples.toArray(new ProjectSampleNode[samples.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.projectSamples;
    }

    @Override
    public Image getImage() {
        return PROJECT_SAMPLES_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.ProjectSamplesNode_NodeName;
    }

    @Override
    public boolean hasChildren() {
        return this.projectSamples.length > 0;
    }

    static enum Property implements IPropertyInformation<ProjectSamplesNode>
    {
        COUNT(Messages.ProjectSamplesNode_Project_Samples_Count){

            @Override
            public Object getPropertyValue(ProjectSamplesNode node) {
                return node.projectSamples.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(ProjectSamplesNode node) {
            return null;
        }
    }
}

