/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.TemplateElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class FileTemplateNode
extends BaseNode<Property> {
    private static final Image FILE_TEMPLATE_ICON = ScriptingUIPlugin.getImage("icons/template.png");
    private TemplateElement fileTemplate;

    FileTemplateNode(TemplateElement fileTemplate) {
        this.fileTemplate = fileTemplate;
    }

    @Override
    public Image getImage() {
        return FILE_TEMPLATE_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.fileTemplate.getDisplayName();
    }

    static enum Property implements IPropertyInformation<FileTemplateNode>
    {
        NAME(Messages.FileTemplateNode_File_Template_Name){

            @Override
            public Object getPropertyValue(FileTemplateNode node) {
                return node.fileTemplate.getDisplayName();
            }
        }
        ,
        PATH(Messages.FileTemplateNode_File_Template_Path){

            @Override
            public Object getPropertyValue(FileTemplateNode node) {
                return node.fileTemplate.getPath();
            }
        }
        ,
        SCOPE(Messages.FileTemplateNode_File_Template_Scope){

            @Override
            public Object getPropertyValue(FileTemplateNode node) {
                String scope = node.fileTemplate.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.FileTemplateNode_All_Scopes;
            }
        }
        ,
        FILE_TYPE(Messages.FileTemplateNode_File_Template_Type){

            @Override
            public Object getPropertyValue(FileTemplateNode node) {
                return node.fileTemplate.getFiletype();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

