/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BuildPathElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class BuildPathNode
extends BaseNode<Property> {
    private static final Image BUILD_PATH_ICON = ScriptingUIPlugin.getImage("icons/template.png");
    private BuildPathElement buildPath;

    BuildPathNode(BuildPathElement buildPath) {
        this.buildPath = buildPath;
    }

    @Override
    public Image getImage() {
        return BUILD_PATH_ICON;
    }

    @Override
    public String getLabel() {
        return this.buildPath.getDisplayName();
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<BuildPathNode>
    {
        NAME(Messages.BuildPathNode_Build_Path_Name){

            @Override
            public Object getPropertyValue(BuildPathNode node) {
                return node.buildPath.getDisplayName();
            }
        }
        ,
        PATH(Messages.BuildPathNode_Build_Path_Path){

            @Override
            public Object getPropertyValue(BuildPathNode node) {
                return node.buildPath.getPath();
            }
        }
        ,
        SCOPE(Messages.BuildPathNode_Build_Path_Scope){

            @Override
            public Object getPropertyValue(BuildPathNode node) {
                String scope = node.buildPath.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.BuildPathNode_All_Scopes;
            }
        }
        ,
        BUILD_PATH(Messages.BuildPathNode_Build_Path_Build_Path){

            @Override
            public Object getPropertyValue(BuildPathNode node) {
                return node.buildPath.getBuildPath();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

