/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui;

import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MenuDialog
extends QuickMenuDialog {
    private static final String TITLE = "title";
    private static final String SEPARATOR = "separator";
    private static final String IMAGE = "image";
    private static final String DISPLAY = "display";

    public MenuDialog(Shell parent, Map<String, Object> ... menuItems) {
        super(parent);
        this.setInput(this.createItems(Arrays.asList(menuItems)));
    }

    private List<MenuDialogItem> createItems(List<Map<String, Object>> partialMatches) {
        ArrayList<MenuDialogItem> items = new ArrayList<MenuDialogItem>();
        Map<String, Object> rep = partialMatches.iterator().next();
        if (rep.containsKey(TITLE)) {
            for (Map<String, Object> map : partialMatches) {
                if (map.containsKey(SEPARATOR)) {
                    items.add(MenuDialogItem.SEPARATOR);
                    continue;
                }
                String title = (String)map.get(TITLE);
                if (title.trim().equals("---")) {
                    items.add(MenuDialogItem.SEPARATOR);
                    continue;
                }
                items.add(new MenuDialogItem(title));
            }
        } else {
            for (Map<String, Object> map : partialMatches) {
                if (map.containsKey(SEPARATOR)) {
                    items.add(MenuDialogItem.SEPARATOR);
                    continue;
                }
                String filename = (String)map.get(IMAGE);
                Image image = null;
                if (filename != null && filename.trim().length() > 0) {
                    try {
                        image = new Image((Device)Display.getCurrent(), filename);
                    }
                    catch (Exception exception) {}
                }
                items.add(new MenuDialogItem((String)map.get(DISPLAY), image));
            }
        }
        return items;
    }
}

